# 機能設計書 95-Dark+（デフォルト）

## 概要

本ドキュメントは、VS Code拡張機能「theme-defaults」のDark+カラーテーマに関する設計仕様を記載する。

### 本機能の処理概要

VS Codeのデフォルトダークテーマである「Dark+」を提供する機能。エディタ、ワークベンチ、ターミナル、シンタックスハイライトの配色を定義し、長時間のコーディング作業でも目に優しい暗色系のUIを実現する。

**業務上の目的・背景**：ダークテーマは現代の開発環境において標準的な選択肢となっている。目の疲労軽減、電力消費削減（OLED）、そして多くの開発者の好みに合致するため、高品質なデフォルトダークテーマの提供が必要。VS Codeの「顔」となるテーマとして、プロフェッショナルな外観と高い可読性を両立させる。

**機能の利用シーン**：
- VS Codeを初めてインストールした際のデフォルト表示
- ダークテーマを好むユーザーの日常的な開発作業
- 暗い環境（夜間作業等）でのコーディング
- プレゼンテーションやスクリーンショット撮影時

**主要な処理内容**：
1. VS Codeの内部Dark UIテーマ（vs-dark）の拡張
2. エディタ背景色・前景色の定義
3. シンタックスハイライト色の定義（TextMateスコープ）
4. セマンティックハイライト色の定義
5. ワークベンチUIカラーのカスタマイズ

**関連システム・外部連携**：VS Codeテーマエンジン、TextMate文法、セマンティックトークンAPI。

**権限による制御**：特別な権限制御はなし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | エディタ | 主画面 | シンタックスハイライト適用 |
| - | ワークベンチ全体 | 主画面 | UIカラー適用 |
| - | 設定 > テーマ | 参照画面 | テーマ選択 |

## 機能種別

UI/UXデザイン / 視覚的カスタマイズ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| - | - | - | テーマ選択のみで入力パラメータなし | - |

### 入力データソース

VS Code設定 workbench.colorTheme

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| colors | object | ワークベンチUIカラー定義 |
| tokenColors | array | TextMateスコープカラー定義 |
| semanticTokenColors | object | セマンティックトークンカラー定義 |

### 出力先

VS Codeレンダリングエンジン

## 処理フロー

### 処理シーケンス

```
1. テーマ選択
   └─ ユーザーがDark+を選択
2. テーマファイル読み込み
   └─ dark_plus.jsonの読み込み
3. ベーステーマ適用
   └─ vs-dark UIテーマの適用
4. カラー定義適用
   └─ colors, tokenColors, semanticTokenColorsの適用
5. レンダリング
   └─ エディタ・UI全体の再描画
```

### フローチャート

```mermaid
flowchart TD
    A[テーマ選択: Dark+] --> B[dark_plus.json読み込み]
    B --> C[vs-dark UIテーマ適用]
    C --> D[tokenColors適用]
    D --> E[semanticTokenColors適用]
    E --> F[UI再描画]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-95-1 | ベーステーマ継承 | vs-darkをベースに拡張 | 常時 |
| BR-95-2 | セマンティックハイライト有効 | semanticHighlighting: true | 常時 |
| BR-95-3 | デフォルトテーマ | 初期インストール時のデフォルト | 新規インストール時 |

### 計算ロジック

該当なし（静的定義）

## データベース操作仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | テーマファイル破損 | JSONパースエラー | フォールバックテーマ適用 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

テーマ適用は即座（100ms以内）に完了すること。

## セキュリティ考慮事項

テーマファイルはJSONのみで実行コードを含まないため、セキュリティリスクは低い。

## 備考

Dark+はDark（シンプル）の拡張版で、より多くのシンタックスハイライト定義を含む。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: テーマ構造を理解する

テーマ定義の全体構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | package.json | `extensions/theme-defaults/package.json` | themes配列でのテーマ登録 |
| 1-2 | dark_plus.json | `extensions/theme-defaults/themes/dark_plus.json` | テーマ本体定義 |

**読解のコツ**: `uiTheme: vs-dark`がベーステーマ、`include`で他のテーマファイルを継承可能。

#### Step 2: カラー定義を理解する

ワークベンチUIとエディタのカラー定義。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | dark_plus.json | `extensions/theme-defaults/themes/dark_plus.json` | colors オブジェクト |

**主要カラー**:
- `editor.background`: エディタ背景色
- `editor.foreground`: エディタ前景色
- `activityBar.background`: アクティビティバー背景
- `sideBar.background`: サイドバー背景

#### Step 3: トークンカラーを理解する

シンタックスハイライトの色定義。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | dark_plus.json | `extensions/theme-defaults/themes/dark_plus.json` | tokenColors 配列 |

**主要スコープ**:
- `comment`: コメント色（#6A9955）
- `keyword`: キーワード色（#569CD6）
- `string`: 文字列色（#CE9178）
- `entity.name.function`: 関数名色（#DCDCAA）
- `entity.name.type`: 型名色（#4EC9B0）

#### Step 4: セマンティックトークンを理解する

言語サーバーベースの高度なハイライト。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | dark_plus.json | `extensions/theme-defaults/themes/dark_plus.json` | semanticTokenColors |

**主要トークン**:
- `variable`: 変数色
- `function`: 関数色
- `type`: 型色
- `namespace`: 名前空間色

### プログラム呼び出し階層図

```
package.json (テーマ登録)
    │
    └─ themes/dark_plus.json
           │
           ├─ $schema (テーマスキーマ)
           ├─ name: "Dark+ (default dark)"
           ├─ type: "dark"
           │
           ├─ colors (UIカラー)
           │      ├─ editor.*
           │      ├─ activityBar.*
           │      └─ ...
           │
           ├─ tokenColors (TextMateスコープ)
           │      ├─ comment
           │      ├─ keyword
           │      ├─ string
           │      └─ ...
           │
           └─ semanticTokenColors
                  ├─ variable
                  ├─ function
                  └─ ...
```

### データフロー図

```
[入力]                    [処理]                         [出力]

テーマ選択 ───▶ テーマエンジン ───▶ UI描画
(Dark+)            │
                   ├─ JSONパース
                   ├─ カラー値解決
                   └─ CSS変数生成

ソースコード ───▶ TextMate文法 ───▶ ハイライト表示
                   │
                   └─ tokenColors照合
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| package.json | `extensions/theme-defaults/package.json` | 設定 | テーマ登録マニフェスト |
| dark_plus.json | `extensions/theme-defaults/themes/dark_plus.json` | テーマ定義 | Dark+テーマ本体 |
| dark_vs.json | `extensions/theme-defaults/themes/dark_vs.json` | テーマ定義 | Darkテーマ（シンプル版） |
| light_plus.json | `extensions/theme-defaults/themes/light_plus.json` | テーマ定義 | Light+テーマ |
| light_vs.json | `extensions/theme-defaults/themes/light_vs.json` | テーマ定義 | Lightテーマ |
| hc_black.json | `extensions/theme-defaults/themes/hc_black.json` | テーマ定義 | ハイコントラストダーク |
