# 機能設計書 96-Monokai

## 概要

本ドキュメントは、VS Code拡張機能「theme-monokai」のMonokaiカラーテーマに関する設計仕様を記載する。

### 本機能の処理概要

Sublime Textで有名になったMonokaiカラースキームをVS Code向けに移植したテーマ。鮮やかで温かみのある配色が特徴で、視認性が高く長時間のコーディングに適している。

**業務上の目的・背景**：MonokaiはSublime Textのデフォルトテーマとして広く認知され、多くの開発者に愛用されてきた。Sublime TextからVS Codeに移行するユーザーや、鮮やかな配色を好むユーザーのために、本格的なMonokaiテーマを標準で提供する。

**機能の利用シーン**：
- 鮮やかな配色を好むユーザーの日常的な開発作業
- Sublime Textから移行してきたユーザーの環境統一
- ダークテーマでありながら活気のある配色を求める場合
- Python、JavaScript等のWeb開発での使用

**主要な処理内容**：
1. VS Codeの内部Dark UIテーマ（vs-dark）の拡張
2. Monokai配色に基づくシンタックスハイライト定義
3. ワークベンチUIカラーのカスタマイズ
4. セマンティックハイライトのサポート

**関連システム・外部連携**：VS Codeテーマエンジン、TextMate文法。

**権限による制御**：特別な権限制御はなし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | エディタ | 主画面 | シンタックスハイライト適用 |
| - | ワークベンチ全体 | 主画面 | UIカラー適用 |
| - | 設定 > テーマ | 参照画面 | テーマ選択 |

## 機能種別

UI/UXデザイン / 視覚的カスタマイズ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| - | - | - | テーマ選択のみで入力パラメータなし | - |

### 入力データソース

VS Code設定 workbench.colorTheme

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| colors | object | ワークベンチUIカラー定義 |
| tokenColors | array | TextMateスコープカラー定義 |

### 出力先

VS Codeレンダリングエンジン

## 処理フロー

### 処理シーケンス

```
1. テーマ選択
   └─ ユーザーがMonokaiを選択
2. テーマファイル読み込み
   └─ monokai-color-theme.jsonの読み込み
3. ベーステーマ適用
   └─ vs-dark UIテーマの適用
4. カラー定義適用
   └─ colors, tokenColorsの適用
5. レンダリング
   └─ エディタ・UI全体の再描画
```

### フローチャート

```mermaid
flowchart TD
    A[テーマ選択: Monokai] --> B[monokai-color-theme.json読み込み]
    B --> C[vs-dark UIテーマ適用]
    C --> D[Monokai配色適用]
    D --> E[UI再描画]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-96-1 | ベーステーマ継承 | vs-darkをベースに拡張 | 常時 |
| BR-96-2 | オリジナル配色準拠 | Sublime Text版Monokaiの配色を踏襲 | 常時 |

### 計算ロジック

該当なし（静的定義）

## データベース操作仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | テーマファイル破損 | JSONパースエラー | フォールバックテーマ適用 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

テーマ適用は即座（100ms以内）に完了すること。

## セキュリティ考慮事項

テーマファイルはJSONのみで実行コードを含まないため、セキュリティリスクは低い。

## 備考

Monokaiの名前はWim Coenらが作成したオリジナルテーマに由来する。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: テーマ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | package.json | `extensions/theme-monokai/package.json` | テーマ登録 |
| 1-2 | monokai-color-theme.json | `extensions/theme-monokai/themes/monokai-color-theme.json` | テーマ本体 |

**読解のコツ**: Monokai特有の鮮やかな色（ピンク、グリーン、イエロー、オレンジ）に注目。

#### Step 2: Monokai配色を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | monokai-color-theme.json | `extensions/theme-monokai/themes/monokai-color-theme.json` | tokenColors |

**Monokai配色の特徴**:
- 背景: #272822（暗いオリーブグリーン）
- コメント: #88846F（グレー）
- キーワード: #F92672（ピンク/マゼンタ）
- 文字列: #E6DB74（イエロー）
- 関数: #A6E22E（ライムグリーン）
- 数値: #AE81FF（パープル）

### プログラム呼び出し階層図

```
package.json (テーマ登録)
    │
    └─ themes/monokai-color-theme.json
           │
           ├─ name: "Monokai"
           ├─ type: "dark"
           │
           ├─ colors
           │      └─ editor.background: #272822
           │
           └─ tokenColors
                  ├─ comment: #88846F
                  ├─ keyword: #F92672
                  ├─ string: #E6DB74
                  ├─ function: #A6E22E
                  └─ number: #AE81FF
```

### データフロー図

```
[入力]                    [処理]                         [出力]

テーマ選択 ───▶ テーマエンジン ───▶ UI描画
(Monokai)           │
                    └─ Monokai配色適用
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| package.json | `extensions/theme-monokai/package.json` | 設定 | テーマ登録 |
| monokai-color-theme.json | `extensions/theme-monokai/themes/monokai-color-theme.json` | テーマ定義 | Monokaiテーマ本体 |
