# 機能設計書 97-Solarized

## 概要

本ドキュメントは、VS Code拡張機能「theme-solarized-dark」のSolarized Darkカラーテーマに関する設計仕様を記載する。

### 本機能の処理概要

Ethan Schoonooverが開発したSolarizedカラースキームのダークバリアントをVS Code向けに実装したテーマ。科学的に設計された16色パレットに基づき、目の疲労を軽減しながら高い可読性を実現する。

**業務上の目的・背景**：Solarizedは科学的なアプローチで設計されたカラースキームで、CIELAB色空間に基づく精密な色選定が特徴。コントラスト比が最適化されており、長時間の作業でも目の疲労が少ない。ターミナル、エディタ、Webサイト等で幅広く採用されており、多くの開発者に支持されている。

**機能の利用シーン**：
- 目の疲労を軽減したいユーザーの長時間作業
- ターミナル環境とエディタの配色を統一したい場合
- 科学的に最適化された配色を好むユーザー
- ブルーグリーン系の落ち着いた配色を好む場合

**主要な処理内容**：
1. VS Codeの内部Dark UIテーマ（vs-dark）の拡張
2. Solarized配色に基づくシンタックスハイライト定義
3. ワークベンチUIカラーのカスタマイズ
4. 8色のアクセントカラーによる構文区別

**関連システム・外部連携**：VS Codeテーマエンジン、TextMate文法。

**権限による制御**：特別な権限制御はなし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | エディタ | 主画面 | シンタックスハイライト適用 |
| - | ワークベンチ全体 | 主画面 | UIカラー適用 |
| - | 設定 > テーマ | 参照画面 | テーマ選択 |

## 機能種別

UI/UXデザイン / 視覚的カスタマイズ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| - | - | - | テーマ選択のみで入力パラメータなし | - |

### 入力データソース

VS Code設定 workbench.colorTheme

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| colors | object | ワークベンチUIカラー定義 |
| tokenColors | array | TextMateスコープカラー定義 |

### 出力先

VS Codeレンダリングエンジン

## 処理フロー

### 処理シーケンス

```
1. テーマ選択
   └─ ユーザーがSolarized Darkを選択
2. テーマファイル読み込み
   └─ solarized-dark-color-theme.jsonの読み込み
3. ベーステーマ適用
   └─ vs-dark UIテーマの適用
4. カラー定義適用
   └─ colors, tokenColorsの適用
5. レンダリング
   └─ エディタ・UI全体の再描画
```

### フローチャート

```mermaid
flowchart TD
    A[テーマ選択: Solarized Dark] --> B[solarized-dark-color-theme.json読み込み]
    B --> C[vs-dark UIテーマ適用]
    C --> D[Solarized配色適用]
    D --> E[UI再描画]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-97-1 | ベーステーマ継承 | vs-darkをベースに拡張 | 常時 |
| BR-97-2 | Solarizedパレット準拠 | オリジナルの16色パレットを使用 | 常時 |
| BR-97-3 | 背景Base03 | ダークテーマはBase03を背景に使用 | 常時 |

### 計算ロジック

該当なし（静的定義）

## データベース操作仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | テーマファイル破損 | JSONパースエラー | フォールバックテーマ適用 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

テーマ適用は即座（100ms以内）に完了すること。

## セキュリティ考慮事項

テーマファイルはJSONのみで実行コードを含まないため、セキュリティリスクは低い。

## 備考

Solarizedパレット: Base色（背景/前景用）8色 + アクセント色8色で構成。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: テーマ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | package.json | `extensions/theme-solarized-dark/package.json` | テーマ登録 |
| 1-2 | solarized-dark-color-theme.json | `extensions/theme-solarized-dark/themes/solarized-dark-color-theme.json` | テーマ本体 |

**読解のコツ**: Solarizedの16色パレットを理解することが重要。

#### Step 2: Solarized配色を理解する

**Solarizedパレット（16色）**:

| Base色 | Hex | 用途 |
|--------|-----|------|
| Base03 | #002b36 | ダーク背景 |
| Base02 | #073642 | ダークハイライト |
| Base01 | #586e75 | コメント |
| Base00 | #657b83 | ライト前景 |
| Base0 | #839496 | ダーク前景 |
| Base1 | #93a1a1 | ライトコメント |
| Base2 | #eee8d5 | ライト背景ハイライト |
| Base3 | #fdf6e3 | ライト背景 |

| アクセント色 | Hex | 用途 |
|-------------|-----|------|
| Yellow | #b58900 | 定数 |
| Orange | #cb4b16 | エラー |
| Red | #dc322f | 重要 |
| Magenta | #d33682 | キーワード |
| Violet | #6c71c4 | 変数 |
| Blue | #268bd2 | 関数 |
| Cyan | #2aa198 | 文字列 |
| Green | #859900 | コメント |

### プログラム呼び出し階層図

```
package.json (テーマ登録)
    │
    └─ themes/solarized-dark-color-theme.json
           │
           ├─ name: "Solarized Dark"
           ├─ type: "dark"
           │
           ├─ colors
           │      └─ editor.background: #002b36 (Base03)
           │
           └─ tokenColors
                  ├─ comment: #586e75 (Base01)
                  ├─ string: #2aa198 (Cyan)
                  ├─ keyword: #859900 (Green)
                  └─ function: #268bd2 (Blue)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

テーマ選択 ───▶ テーマエンジン ───▶ UI描画
(Solarized)         │
                    └─ Solarizedパレット適用
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| package.json | `extensions/theme-solarized-dark/package.json` | 設定 | テーマ登録 |
| solarized-dark-color-theme.json | `extensions/theme-solarized-dark/themes/solarized-dark-color-theme.json` | テーマ定義 | Solarized Darkテーマ本体 |
