# 機能設計書 99-Setiアイコン

## 概要

本ドキュメントは、VS Code拡張機能「theme-seti」のSeti UIファイルアイコンテーマに関する設計仕様を記載する。

### 本機能の処理概要

Seti UIプロジェクトに基づくファイルアイコンテーマを提供する機能。ファイルの種類（拡張子、ファイル名）やフォルダに応じた視覚的なアイコンを表示し、プロジェクト構造の把握を容易にする。

**業務上の目的・背景**：大規模なプロジェクトでは数百〜数千のファイルが存在し、ファイル名だけでは種類を瞬時に判別することが困難。ファイルアイコンにより、JavaScript、TypeScript、Python、設定ファイル等を視覚的に区別でき、ナビゲーション効率が大幅に向上する。Seti UIはAtomエディタで人気を博したアイコンセットであり、多くの開発者に馴染みがある。

**機能の利用シーン**：
- エクスプローラーでのファイル種類の視覚的識別
- タブバーでの開いているファイルの種類確認
- パンくずリストでのファイル種類表示
- プロジェクト全体の構造把握

**主要な処理内容**：
1. ファイル拡張子に基づくアイコンマッピング
2. 特定ファイル名に基づくアイコンマッピング（package.json, .gitignore等）
3. フォルダ名に基づくアイコンマッピング
4. 言語IDに基づくアイコンマッピング
5. SVGアイコンのレンダリング

**関連システム・外部連携**：VS Codeファイルアイコンテーマエンジン。

**権限による制御**：特別な権限制御はなし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | エクスプローラー | 主画面 | ファイル/フォルダアイコン表示 |
| - | タブバー | 参照画面 | 開いているファイルのアイコン表示 |
| - | パンくずリスト | 参照画面 | パス内ファイルのアイコン表示 |
| - | 設定 > ファイルアイコンテーマ | 参照画面 | テーマ選択 |

## 機能種別

UI/UXデザイン / 視覚的カスタマイズ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ファイル名 | string | Yes | アイコン対象のファイル名 | - |
| 拡張子 | string | No | ファイル拡張子 | - |
| 言語ID | string | No | VS Code言語識別子 | - |
| フォルダ名 | string | No | フォルダ名 | - |

### 入力データソース

ファイルシステム情報、VS Code言語登録情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| iconPath | string | アイコンSVGファイルパス |
| fontCharacter | string | フォントアイコン文字（使用する場合） |

### 出力先

VS Codeエクスプローラー、タブバー等のUI要素

## 処理フロー

### 処理シーケンス

```
1. ファイル情報取得
   └─ ファイル名、拡張子、言語IDの取得
2. アイコン解決
   └─ 優先順位: ファイル名 > 拡張子 > 言語ID > デフォルト
3. SVGアイコン取得
   └─ 対応するSVGファイルのパス解決
4. レンダリング
   └─ UIへのアイコン表示
```

### フローチャート

```mermaid
flowchart TD
    A[ファイル情報] --> B{ファイル名マッチ?}
    B -->|Yes| C[ファイル名アイコン]
    B -->|No| D{拡張子マッチ?}
    D -->|Yes| E[拡張子アイコン]
    D -->|No| F{言語IDマッチ?}
    F -->|Yes| G[言語アイコン]
    F -->|No| H[デフォルトアイコン]
    C --> I[アイコン表示]
    E --> I
    G --> I
    H --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-99-1 | ファイル名優先 | 特定ファイル名は拡張子より優先 | package.json等 |
| BR-99-2 | フォルダアイコン | フォルダ名に応じた専用アイコン | node_modules等 |
| BR-99-3 | 開閉状態 | フォルダは開閉状態でアイコン変化 | フォルダ展開時 |
| BR-99-4 | ライトテーマ対応 | ライトテーマ用の別アイコン | ライトテーマ使用時 |

### 計算ロジック

アイコン解決優先順位:
1. fileNames (完全一致)
2. fileExtensions (拡張子マッチ)
3. languageIds (言語ID)
4. file (デフォルトファイルアイコン)

## データベース操作仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | アイコン未発見 | マッピング外のファイル | デフォルトアイコン使用 |
| - | SVGロードエラー | SVGファイル破損 | フォールバックアイコン |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

アイコン解決は即座（10ms以内）に完了すること。

## セキュリティ考慮事項

SVGファイルは静的リソースのため、セキュリティリスクは低い。

## 備考

Seti UIはJesse Weedが開発したAtomエディタ用テーマが起源。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: アイコンテーマ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | package.json | `extensions/theme-seti/package.json` | iconThemes登録 |
| 1-2 | vs-seti-icon-theme.json | `extensions/theme-seti/icons/vs-seti-icon-theme.json` | アイコンマッピング定義 |

**読解のコツ**: `iconDefinitions`でアイコン定義、`fileExtensions`/`fileNames`/`folderNames`でマッピング。

#### Step 2: アイコンマッピングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | vs-seti-icon-theme.json | `extensions/theme-seti/icons/vs-seti-icon-theme.json` | マッピングセクション |

**主要マッピング例**:
- fileExtensions: `"js": "_javascript"`, `"ts": "_typescript"`
- fileNames: `"package.json": "_npm"`, `".gitignore": "_git"`
- folderNames: `"node_modules": "_folder_node"`, `"src": "_folder_src"`

#### Step 3: SVGアイコンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | seti.woff | `extensions/theme-seti/icons/seti.woff` | アイコンフォント |

**主要アイコン**:
- JavaScript, TypeScript, Python等のプログラミング言語
- HTML, CSS, JSON等のマークアップ/データ形式
- Git, NPM, Docker等のツール関連

### プログラム呼び出し階層図

```
package.json (アイコンテーマ登録)
    │
    └─ icons/vs-seti-icon-theme.json
           │
           ├─ iconDefinitions
           │      ├─ _javascript
           │      ├─ _typescript
           │      ├─ _python
           │      └─ ...
           │
           ├─ fileExtensions
           │      ├─ "js" -> "_javascript"
           │      ├─ "ts" -> "_typescript"
           │      └─ ...
           │
           ├─ fileNames
           │      ├─ "package.json" -> "_npm"
           │      ├─ ".gitignore" -> "_git"
           │      └─ ...
           │
           ├─ folderNames
           │      ├─ "node_modules" -> "_folder_node"
           │      ├─ "src" -> "_folder_src"
           │      └─ ...
           │
           └─ languageIds
                  ├─ "javascript" -> "_javascript"
                  └─ ...
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ファイル情報 ───▶ アイコン解決 ───▶ アイコン表示
(名前/拡張子)        │
                     ├─ fileNamesチェック
                     ├─ fileExtensionsチェック
                     ├─ languageIdsチェック
                     └─ デフォルト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| package.json | `extensions/theme-seti/package.json` | 設定 | アイコンテーマ登録 |
| vs-seti-icon-theme.json | `extensions/theme-seti/icons/vs-seti-icon-theme.json` | テーマ定義 | アイコンマッピング |
| seti.woff | `extensions/theme-seti/icons/seti.woff` | フォント | アイコンフォント |
