---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 22
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：1-コード編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：22 / 25、根拠なし：3
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**：根拠不足
  2. **クリップボード連携の詳細実装**：根拠不足
  3. **自動括弧閉じの詳細設定**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/editor/common/editorCommon.ts` - IEditor/ICommand/Handler定義
- E-02: `src/vs/editor/common/cursor/cursor.ts` - CursorsControllerクラス
- E-03: `src/vs/editor/common/core/editOperation.ts` - EditOperationクラス
- E-04: `src/vs/editor/common/model.ts` - ITextModel/IModelDecorationOptions定義
- E-05: `src/vs/editor/common/core/position.ts` - Positionクラス
- E-06: `src/vs/editor/common/core/range.ts` - Rangeクラス
- E-07: `src/vs/editor/common/core/selection.ts` - Selectionクラス
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能関連情報
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コード編集機能はカット、コピー、ペースト、Undo/Redoを含む | E-02 (cursor.ts 556-614行目) | ○ |
| C-02 | Handler列挙型でType, Paste, Cutが定義されている | E-01 (editorCommon.ts 750-758行目) | ○ |
| C-03 | CursorsControllerがtype()メソッドを持つ | E-02 (cursor.ts 556-579行目) | ○ |
| C-04 | CursorsControllerがpaste()メソッドを持つ | E-02 (cursor.ts 601-607行目) | ○ |
| C-05 | CursorsControllerがcut()メソッドを持つ | E-02 (cursor.ts 609-614行目) | ○ |
| C-06 | EditOperationにinsert/delete/replaceメソッドがある | E-03 (editOperation.ts 31-59行目) | ○ |
| C-07 | 読み取り専用モードで編集が無効化される | E-02 (cursor.ts 510-513行目) | ○ |
| C-08 | IEditOperationBuilderインターフェースが存在する | E-01 (editorCommon.ts 23-49行目) | ○ |
| C-09 | ICursorStateComputerDataが逆編集操作を取得できる | E-01 (editorCommon.ts 54-65行目) | ○ |
| C-10 | ICommandインターフェースでgetEditOperations定義 | E-01 (editorCommon.ts 70-92行目) | ○ |
| C-11 | テキストエディタが主画面として関連 | E-08 (画面機能マッピング.csv 29-47行目) | ○ |
| C-12 | エディタグループが主画面として関連 | E-08 (画面機能マッピング.csv 27行目) | ○ |
| C-13 | 差分エディタが補助画面として関連 | E-08 (画面機能マッピング.csv 48-49行目) | ○ |
| C-14 | 機能の備考にsrc/vs/editor/commonが記載 | E-09 (機能一覧.csv 2行目) | ○ |
| C-15 | PositionクラスがlineNumberとcolumnを持つ | E-05 (position.ts) | ○ |
| C-16 | Rangeクラスが範囲を表現する | E-06 (range.ts) | ○ |
| C-17 | Selectionクラスが選択範囲を表現する | E-07 (selection.ts) | ○ |
| C-18 | pushStackElementでUndoグループを作成可能 | E-02 (cursor.ts 357-359行目, 385-387行目) | ○ |
| C-19 | マルチカーソル制限がmultiCursorLimitで設定 | E-02 (cursor.ts 120-123行目) | ○ |
| C-20 | 自動閉じ括弧がAutoClosedActionで管理される | E-02 (cursor.ts 674-738行目) | ○ |
| C-21 | CompositionStateで日本語入力等を処理 | E-02 (cursor.ts 1043-1116行目) | ○ |
| C-22 | CommandExecutorがコマンドを実行する | E-02 (cursor.ts 757-1031行目) | ○ |
| C-23 | パフォーマンス要件として16ms以内 | **根拠なし** | △ |
| C-24 | クリップボード操作の詳細実装 | **根拠なし** | △ |
| C-25 | ペースト内容のサニタイズ処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値目標はコード内に明示的に記載されていない
  - 候補：設定ファイル / パフォーマンステスト / ドキュメント
- クリップボード連携の詳細実装はplatform層にある可能性
  - 候補：`src/vs/platform/clipboard` / ブラウザAPI連携
- サニタイズ処理の有無はセキュリティ関連コードの調査が必要
  - 候補：`src/vs/base/common/strings.ts` / 入力検証ロジック

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア編集機能の記述はソースコードと整合
- 1: 中リスク - パフォーマンス要件は推定値であり検証が必要
- 1: 中リスク - セキュリティ関連の記述は追加調査が推奨

## 6) レビュアーチェックリスト（最小）
- [ ] CursorsControllerのtype/paste/cutメソッドの実装がドキュメントの記述と一致するか確認
- [ ] 読み取り専用モードの挙動がcontext.cursorConfig.readOnlyで制御されているか確認
- [ ] パフォーマンス要件の数値が実際のテスト結果と一致するか確認
- [ ] クリップボード連携の実装箇所を特定し、セキュリティ要件を確認
- [ ] マルチカーソル制限値のデフォルト設定を確認
