---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：10-ホバー情報

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **ホバー表示300ms以内の根拠**：根拠不足
  2. **XSSサニタイズの詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/editor/contrib/hover/browser/contentHoverController.ts` - ContentHoverController
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能関連情報
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ContentHoverControllerがID 'editor.contrib.contentHover'で登録 | E-01 (44行目) | ○ |
| C-02 | IHoverSettingsでenabled/sticky/hidingDelayを定義 | E-01 (33-37行目) | ○ |
| C-03 | enabledが'on'/'off'/'onKeyboardModifier'の3値 | E-01 (34行目, 101行目) | ○ |
| C-04 | onHoverContentsChangedイベント | E-01 (41-42行目) | ○ |
| C-05 | ContentHoverWidgetWrapperでウィジェット管理 | E-01 (50行目) | ○ |
| C-06 | RunOnceSchedulerで遅延実行 | E-01 (53行目, 67-73行目) | ○ |
| C-07 | _hookListeners()でイベントリスナー登録 | E-01 (94-112行目) | ○ |
| C-08 | onMouseMoveでマウス移動検知 | E-01 (106行目) | ○ |
| C-09 | onMouseDownでマウスダウン検知 | E-01 (104行目) | ○ |
| C-10 | onKeyDownでキー押下検知 | E-01 (107行目) | ○ |
| C-11 | hideContentHover()でホバー非表示 | E-01 (75行目, 120行目, 133行目, 146行目) | ○ |
| C-12 | コンテキストメニュー表示中はホバー無効 | E-01 (74-80行目) | ○ |
| C-13 | スクロール変更時にホバー非表示 | E-01 (128-135行目) | ○ |
| C-14 | テキストエディタが主画面として関連 | E-02 (38行目) | ○ |
| C-15 | 機能の備考にsrc/vs/editor/contrib/hoverが記載 | E-03 (11行目) | ○ |
| C-16 | EditorOption.hoverで設定取得 | E-01 (83行目, 95行目) | ○ |
| C-17 | ホバー表示300ms以内 | **根拠なし** | △ |
| C-18 | XSSサニタイズの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ホバー表示300ms以内は推定値であり、コード内に明示的記載がない
  - 候補：ベンチマークテスト / 設定オプション
- XSSサニタイズの詳細はMarkdownレンダラーで確認が必要
  - 候補：`src/vs/base/browser/markdownRenderer.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラ構造はコードと一致
- 0: 低リスク - 設定オプションはコードで確認可能
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] ContentHoverController.IDが正しく登録されているか確認
- [ ] IHoverSettingsの各オプションの効果を確認
- [ ] イベントリスナーの登録が適切か確認
- [ ] コンテキストメニュー中のホバー無効化が正しく動作するか確認
- [ ] スクロール時のホバー非表示が正しく動作するか確認
