---
generated_at: 2026-01-27 13:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：100-2026テーマ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `extensions/theme-2026/package.json` - テーマ登録マニフェスト
- E-02: `extensions/theme-2026/themes/2026-dark.json` - ダークテーマ定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 2026テーマの登録 | E-01 (themes配列) | ○ |
| C-02 | Light/Dark両バリアント | E-01 (20-30行目) | ○ |
| C-03 | enabledApiProposals: css | E-01 (11-13行目) | ○ |
| C-04 | CSS contributes | E-01 (32-36行目) | ○ |
| C-05 | 2026-dark-experimental id | E-01 (26行目) | ○ |
| C-06 | 2026-light-experimental id | E-01 (21行目) | ○ |
| C-07 | type: dark | E-02 (4行目) | ○ |
| C-08 | 背景色 #121416 | E-02 (103行目) | ○ |
| C-09 | 前景色 #BBBEBF | E-02 (104行目) | ○ |
| C-10 | アクセント色 #498FAE | E-02 (19行目) | ○ |
| C-11 | コメント色 #6A9955 | E-02 (241行目) | ○ |
| C-12 | キーワード色 #569cd6 | E-02 (251行目) | ○ |
| C-13 | semanticHighlighting: true | E-02 (327行目) | ○ |
| C-14 | semanticTokenColors定義 | E-02 (328-333行目) | ○ |
| C-15 | colors定義（233項目以上） | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 実験的テーマのため、API変更の可能性あり
- 0: 低リスク - 配色自体は安定した定義

## 6) レビュアーチェックリスト（最小）
- [ ] CSS API（実験的）の安定性確認
- [ ] アクセシビリティ（WCAGコントラスト比）の検証
- [ ] 各言語でのシンタックスハイライト表示確認
- [ ] Light/Dark両バリアントの整合性確認
