---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-定義へ移動

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **ビジネスルール4「定義が見つからない場合は何もしない」**：エラーメッセージの有無を要確認
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/editor/contrib/gotoSymbol/browser/goToCommands.ts`
- E-02: `src/vs/editor/contrib/gotoSymbol/browser/goToSymbol.ts`
- E-03: `src/vs/editor/contrib/gotoSymbol/browser/link/goToDefinitionAtPosition.ts`
- E-04: `src/vs/editor/contrib/gotoSymbol/browser/referencesModel.ts`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | F12キーで定義へ移動コマンドが実行される | E-01 (KeyCode.F12) | ○ |
| C-02 | Ctrl+クリックで定義へ移動できる | E-03 (ClickLinkGesture) | ○ |
| C-03 | 定義が1つの場合は直接ジャンプ | E-01 (_openReference) | ○ |
| C-04 | 定義が複数の場合はピークビュー表示 | E-01 (toggleWidget) | ○ |
| C-05 | getDefinitionsAtPositionで定義を取得 | E-02 (38-101行) | ○ |
| C-06 | ReferencesModelでデータを管理 | E-04 | ○ |
| C-07 | CancellationTokenでキャンセル対応 | E-02 (token引数) | ○ |
| C-08 | 複数のDefinitionProviderを並列実行 | E-02 (Promise.all) | ○ |
| C-09 | 関連パス:goToCommands.ts | E-01 | ○ |
| C-10 | 関連パス:goToSymbol.ts | E-02 | ○ |
| C-11 | 関連パス:goToDefinitionAtPosition.ts | E-03 | ○ |
| C-12 | 関連パス:referencesModel.ts | E-04 | ○ |
| C-13 | 機能No.11が定義へ移動 | E-05 | ○ |
| C-14 | 関連ディレクトリはsrc/vs/editor/contrib/gotoSymbol | E-05 | ○ |
| C-15 | DefinitionActionクラスがコマンドを実装 | E-01 | ○ |
| C-16 | LocationLink型で定義位置を表現 | E-02 | ○ |
| C-17 | ILanguageFeaturesServiceを通じてプロバイダにアクセス | E-02 (import) | ○ |
| C-18 | 定義が見つからない場合はエラーメッセージ不要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18「定義が見つからない場合はエラーメッセージ不要」について、コード上では`_getNoResultFoundMessage()`メソッドが存在するため、実際の挙動を確認する必要がある
  - 候補：goToCommands.ts内のエラーハンドリング処理 / ユーザー設定による挙動変更の有無

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードとの整合性が高い
- 1: 中リスク - エラーハンドリングの挙動について要確認

## 6) レビュアーチェックリスト（最小）
- [ ] F12キーで定義へ移動できることを実機確認
- [ ] Ctrl+クリックで定義へ移動できることを実機確認
- [ ] 複数定義がある場合のピークビュー表示を確認
- [ ] 定義が見つからない場合の挙動を確認
