---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：12-参照検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **ストリーミング表示機能**：段階的表示の実装詳細要確認
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/references-view/src/extension.ts`
- E-02: `extensions/references-view/src/references/model.ts`
- E-03: `src/vs/editor/contrib/gotoSymbol/browser/goToCommands.ts`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Shift+F12で参照検索が実行される | E-03 | ○ |
| C-02 | References Viewがサイドバーに表示される | E-01 (registerTreeDataProvider) | ○ |
| C-03 | ファイル単位でグループ化される | E-02 (FileItem class) | ○ |
| C-04 | ReferencesModelでデータを管理 | E-02 | ○ |
| C-05 | 拡張機能として実装されている | E-01 (extensions/references-view) | ○ |
| C-06 | TreeDataProviderインターフェースを使用 | E-01 | ○ |
| C-07 | 関連パス:extension.ts | E-01 | ○ |
| C-08 | 関連パス:model.ts | E-02 | ○ |
| C-09 | 機能No.12が参照検索 | E-04 | ○ |
| C-10 | 関連ディレクトリはextensions/references-view | E-04 | ○ |
| C-11 | Location[]で参照位置を表現 | E-02 | ○ |
| C-12 | includeDeclarationフラグがある | E-03 | ○ |
| C-13 | プレビューにコンテキスト情報を含む | E-02 (DocumentHighlight) | ○ |
| C-14 | 非同期で検索を実行 | E-02 (async/await) | ○ |
| C-15 | キャンセルトークンをサポート | E-03 | ○ |
| C-16 | 検索結果のストリーミング表示 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16「検索結果のストリーミング表示」について、コード上での実装詳細を確認する必要がある
  - 候補：model.ts内の段階的ロード処理 / Progress APIの使用

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードとの整合性が高い
- 1: 中リスク - ストリーミング表示の実装詳細について要確認

## 6) レビュアーチェックリスト（最小）
- [ ] Shift+F12で参照検索が実行されることを実機確認
- [ ] References Viewでファイル単位のグループ化を確認
- [ ] 参照をクリックして該当位置へジャンプできることを確認
- [ ] 大規模コードベースでのパフォーマンスを確認
