---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-コードレンズ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/editor/contrib/codelens/browser/codelensController.ts`
- E-02: `src/vs/editor/contrib/codelens/browser/codelensWidget.ts`（ファイル存在確認）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コードの上部にインライン表示 | E-01 | ○ |
| C-02 | CodeLensContributionがCodeLens処理を制御 | E-01 | ○ |
| C-03 | _scheduleUpdate()でデバウンス更新 | E-01 | ○ |
| C-04 | provideCodeLenses()でCodeLensを取得 | E-01 | ○ |
| C-05 | resolveCodeLens()で遅延解決 | E-01 | ○ |
| C-06 | CodeLensWidgetで表示を管理 | E-02 | ○ |
| C-07 | RunOnceSchedulerでデバウンス | E-01 (import) | ○ |
| C-08 | 複数プロバイダの結果をマージ | E-01 | ○ |
| C-09 | 関連パス:codelensController.ts | E-01 | ○ |
| C-10 | 機能No.14がコードレンズ | E-03 | ○ |
| C-11 | 関連ディレクトリはsrc/vs/editor/contrib/codelens | E-03 | ○ |
| C-12 | IEditorContributionを実装 | E-01 | ○ |
| C-13 | キャンセルトークンをサポート | E-01 | ○ |
| C-14 | ILanguageFeaturesServiceを使用 | E-01 (import) | ○ |
| C-15 | ICommandServiceでコマンド実行 | E-01 (import) | ○ |
| C-16 | 可視範囲のみを処理 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、ソースコードとの整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] CodeLensがコード行の上に表示されることを実機確認
- [ ] CodeLensをクリックしてコマンドが実行されることを確認
- [ ] スクロール時にCodeLensが更新されることを確認
- [ ] 複数のCodeLensProviderの結果が表示されることを確認
