---
generated_at: 2026-01-27 10:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-インレイヒント

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/editor/contrib/inlayHints/browser/inlayHintsController.ts`
- E-02: `src/vs/editor/contrib/inlayHints/browser/inlayHints.ts`（ファイル存在確認）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InlayHintsControllerがヒント処理を制御 | E-01 (129行目) | ○ |
| C-02 | InlayHintsCacheでキャッシュ管理 | E-01 (43-66行目) | ○ |
| C-03 | LRUCacheを使用して50エントリ上限 | E-01 (47行目) | ○ |
| C-04 | RenderModeで表示/非表示を制御 | E-01 (93-96行目) | ○ |
| C-05 | _update()で更新処理 | E-01 (179行目) | ○ |
| C-06 | _installLinkGesture()でクリック処理 | E-01 (314行目) | ○ |
| C-07 | ClickLinkGestureでCtrl+クリックを検出 | E-01 (import from clickLinkGesture) | ○ |
| C-08 | 最大1500デコレーションの制限 | E-01 (133行目 _MAX_DECORATORS) | ○ |
| C-09 | InjectedTextOptionsでテキスト挿入 | E-01 (537行目) | ○ |
| C-10 | InlayHintKind.TypeとParameter | E-01 (731-740行目) | ○ |
| C-11 | 可視範囲+30行のバッファ | E-01 (461行目 extra = 30) | ○ |
| C-12 | 関連パス:inlayHintsController.ts | E-01 | ○ |
| C-13 | 機能No.15がインレイヒント | E-03 | ○ |
| C-14 | 関連ディレクトリはsrc/vs/editor/contrib/inlayHints | E-03 | ○ |
| C-15 | IEditorContributionを実装 | E-01 | ○ |
| C-16 | キャンセルトークンをサポート | E-01 | ○ |
| C-17 | DynamicCssRulesで動的スタイル生成 | E-01 (144行目) | ○ |
| C-18 | goToDefinitionWithLocationでジャンプ | E-01 (360行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、ソースコードとの整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] 型推論結果がインライン表示されることを実機確認
- [ ] パラメータ名がインライン表示されることを確認
- [ ] ヒントをクリックして型定義にジャンプできることを確認
- [ ] 設定でヒントの表示/非表示を切り替えられることを確認
- [ ] Ctrl+Alt+Iで表示トグルができることを確認
