---
generated_at: 2026-01-27 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-インデントガイド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/editor/common/model/guidesTextModelPart.ts`
- E-02: `src/vs/editor/common/textModelGuides.ts`（ファイル存在確認）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GuidesTextModelPartがガイド計算を担当 | E-01 (18行目) | ○ |
| C-02 | _computeIndentLevel()でインデントレベル計算 | E-01 (34行目) | ○ |
| C-03 | getActiveIndentGuide()でアクティブガイド計算 | E-01 (41行目) | ○ |
| C-04 | getLinesBracketGuides()でブラケットガイド計算 | E-01 (274行目) | ○ |
| C-05 | getLinesIndentGuides()で行ごとのガイド取得 | E-01 (471行目) | ○ |
| C-06 | offSide言語の特別処理 | E-01 (56行目 foldingRules.offSide) | ○ |
| C-07 | 最大50000行の検索制限 | E-01 (163行目) | ○ |
| C-08 | _getIndentLevelForWhitespaceLine()で空白行処理 | E-01 (562行目) | ○ |
| C-09 | bracketPairsサブシステムと連携 | E-01 (288行目) | ○ |
| C-10 | BracketPairGuidesClassNamesで色分け | E-01 (590行目) | ○ |
| C-11 | 関連パス:guidesTextModelPart.ts | E-01 | ○ |
| C-12 | 機能No.17がインデントガイド | E-03 | ○ |
| C-13 | 関連ディレクトリはsrc/vs/editor/common/model | E-03 | ○ |
| C-14 | TextModelPartを継承 | E-01 (18行目) | ○ |
| C-15 | IActiveIndentGuideInfo型を返す | E-01 (41行目) | ○ |
| C-16 | BugIndicatingErrorを使用 | E-01 (50行目) | ○ |
| C-17 | ILanguageConfigurationServiceを使用 | E-01 (21行目) | ○ |
| C-18 | computeIndentLevelをutils.tsからインポート | E-01 (13行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、ソースコードとの整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] インデントガイドが表示されることを実機確認
- [ ] カーソル位置に応じてアクティブガイドがハイライトされることを確認
- [ ] Python等のoffSide言語で正しく動作することを確認
- [ ] 空白行でガイドが継続表示されることを確認
- [ ] ブラケットガイドが括弧ペアに対応していることを確認
