---
generated_at: 2026-01-27 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-行番号表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/editor/browser/viewParts/lineNumbers/lineNumbers.ts`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LineNumbersOverlayが行番号表示を制御 | E-01 (21行目) | ○ |
| C-02 | CLASS_NAME = 'line-numbers' | E-01 (23行目) | ○ |
| C-03 | _readConfig()で設定読み込み | E-01 (49行目) | ○ |
| C-04 | onCursorStateChanged()でカーソル変更処理 | E-01 (73行目) | ○ |
| C-05 | _getLineRenderLineNumber()で行番号計算 | E-01 (111行目) | ○ |
| C-06 | prepareRender()でレンダリング準備 | E-01 (147行目) | ○ |
| C-07 | render()で実際の描画 | E-01 (208行目) | ○ |
| C-08 | RenderLineNumbersType.Relativeで相対行番号 | E-01 (122行目) | ○ |
| C-09 | RenderLineNumbersType.Intervalで間隔行番号 | E-01 (130行目) | ○ |
| C-10 | _lastCursorModelPositionとの差分計算 | E-01 (123行目) | ○ |
| C-11 | renderCustomLineNumbersでカスタム関数 | E-01 (118行目) | ○ |
| C-12 | 関連パス:lineNumbers.ts | E-01 | ○ |
| C-13 | 機能No.18が行番号表示 | E-02 | ○ |
| C-14 | 関連ディレクトリはsrc/vs/editor/browser | E-02 | ○ |
| C-15 | DynamicViewOverlayを継承 | E-01 (21行目) | ○ |
| C-16 | renderFinalNewline設定対応 | E-01 (188行目) | ○ |
| C-17 | active-line-numberクラスでアクティブ行 | E-01 (196行目) | ○ |
| C-18 | registerThemingParticipantでテーマ対応 | E-01 (220行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、ソースコードとの整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] 行番号が表示されることを実機確認
- [ ] 相対行番号モードで現在行からの距離が表示されることを確認
- [ ] 間隔モードで10行ごとに番号が表示されることを確認
- [ ] 現在行がハイライトされることを確認
- [ ] 設定で行番号をオフにできることを確認
