---
generated_at: 2026-01-27 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-ミニマップ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/editor/browser/viewParts/minimap/minimap.ts`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MinimapOptionsクラスが設定を管理 | E-01 (50行目) | ○ |
| C-02 | MinimapLayoutクラスがレイアウト計算 | E-01 (214行目) | ○ |
| C-03 | MinimapSamplingStateがサンプリング管理 | E-01 (616行目) | ○ |
| C-04 | RenderMinimap列挙型（None/Text/Blocks） | E-01 (16行目 import) | ○ |
| C-05 | POINTER_DRAG_RESET_DISTANCE = 140 | E-01 (46行目) | ○ |
| C-06 | MinimapBuffersでダブルバッファリング | E-01 (513行目) | ○ |
| C-07 | getDesiredScrollTopFromDelta()でスクロール計算 | E-01 (252行目) | ○ |
| C-08 | intersectWithViewport()で範囲交差計算 | E-01 (263行目) | ○ |
| C-09 | MinimapLayout.create()でレイアウト生成 | E-01 (280行目) | ○ |
| C-10 | MinimapSamplingState.compute()でサンプリング計算 | E-01 (618行目) | ○ |
| C-11 | equals()メソッドで変更検出 | E-01 (181行目) | ○ |
| C-12 | 関連パス:minimap.ts | E-01 | ○ |
| C-13 | 機能No.19がミニマップ | E-02 | ○ |
| C-14 | 関連ディレクトリはsrc/vs/editor/browser/viewParts/minimap | E-02 | ○ |
| C-15 | GlobalPointerMoveMonitorをインポート | E-01 (9行目) | ○ |
| C-16 | MinimapTokensColorTrackerを使用 | E-01 (24行目 import) | ○ |
| C-17 | Canvas APIを使用 | E-01 (ImageData使用) | ○ |
| C-18 | size設定: proportional/fill/fit | E-01 (53行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、ソースコードとの整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] ミニマップが表示されることを実機確認
- [ ] ミニマップをクリックして該当位置にジャンプできることを確認
- [ ] スライダーをドラッグしてスクロールできることを確認
- [ ] 大きなファイルでサンプリングモードが動作することを確認
- [ ] エラー/警告のデコレーションが表示されることを確認
- [ ] 設定でミニマップを無効にできることを確認
