---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：2-シンタックスハイライト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**：根拠不足
  2. **vscode-textmate連携の詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/editor/common/encodedTokenAttributes.ts` - トークンメタデータ定義
- E-02: `src/vs/editor/common/tokenizationRegistry.ts` - トークナイゼーション登録
- E-03: `src/vs/editor/common/tokens/lineTokens.ts` - LineTokensクラス
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能関連情報
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | トークンメタデータは32ビット整数でエンコード | E-01 (45-95行目) | ○ |
| C-02 | FontStyleは太字、斜体、下線、取り消し線を含む | E-01 (17-24行目) | ○ |
| C-03 | StandardTokenTypeにComment, String, RegExがある | E-01 (38-43行目) | ○ |
| C-04 | TokenizationRegistryがトークナイザを管理 | E-02 (12-113行目) | ○ |
| C-05 | register()で言語IDに対してサポートを登録 | E-02 (33-43行目) | ○ |
| C-06 | get()で言語IDからサポートを取得 | E-02 (45-47行目) | ○ |
| C-07 | getOrCreate()で遅延ロードを含む取得 | E-02 (63-79行目) | ○ |
| C-08 | setColorMap()でカラーマップを設定 | E-02 (95-101行目) | ○ |
| C-09 | LineTokensがUint32Arrayでトークンを管理 | E-03 (32-112行目) | ○ |
| C-10 | getClassName()でCSSクラス名を生成 | E-03 (178-181行目) | ○ |
| C-11 | getInlineStyle()でインラインスタイルを生成 | E-03 (183-186行目) | ○ |
| C-12 | findTokenIndexAtOffset()でトークン検索 | E-03 (202-204行目) | ○ |
| C-13 | TokenMetadata.getLanguageId()で言語ID抽出 | E-01 (101-103行目) | ○ |
| C-14 | TokenMetadata.getForeground()で前景色抽出 | E-01 (117-119行目) | ○ |
| C-15 | getClassNameFromMetadata()でmtkXクラス生成 | E-01 (125-144行目) | ○ |
| C-16 | テキストエディタが主画面として関連 | E-04 (30行目) | ○ |
| C-17 | 機能の備考にvscode-textmate使用と記載 | E-05 (3行目) | ○ |
| C-18 | トークン長とテキスト長の不一致でエラー | E-03 (104-107行目) | ○ |
| C-19 | SliceLineTokensで部分トークン取得 | E-03 (305-411行目) | ○ |
| C-20 | TokenArrayBuilderでトークン配列構築 | E-03 (516-525行目) | ○ |
| C-21 | パフォーマンス要件として行あたり1ms以内 | **根拠なし** | △ |
| C-22 | vscode-textmateライブラリの詳細連携 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は推定値であり、コード内に明示的な記載がない
  - 候補：ベンチマークテスト / 設計ドキュメント
- vscode-textmateとの連携詳細は外部依存ライブラリのため本リポジトリ内に情報がない
  - 候補：`node_modules/vscode-textmate` / 外部ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - トークンメタデータのエンコード形式はコードと完全一致
- 0: 低リスク - LineTokensクラスの機能はコードで検証可能
- 1: 中リスク - パフォーマンス要件は実測値の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] MetadataConstsのビットマスク値がドキュメントの記述と一致するか確認
- [ ] TokenMetadataのメソッドが正しくビット操作を行っているか確認
- [ ] LineTokensのUint32Array構造（endOffset, metadataのペア）を確認
- [ ] getClassNameFromMetadata()のCSSクラス生成ロジックを確認
- [ ] vscode-textmateとの統合ポイントを特定
