---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-スティッキースクロール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/editor/contrib/stickyScroll/browser/stickyScrollController.ts`
- E-02: `src/vs/editor/contrib/stickyScroll/browser/stickyScrollWidget.ts`（ファイル存在確認）
- E-03: `src/vs/editor/contrib/stickyScroll/browser/stickyScrollProvider.ts`（ファイル存在確認）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StickyScrollControllerがスティッキースクロール処理を制御 | E-01 (50行目) | ○ |
| C-02 | IStickyScrollControllerインターフェースを定義 | E-01 (35行目) | ○ |
| C-03 | focus()でフォーカス処理 | E-01 (181行目) | ○ |
| C-04 | goToFocused()でジャンプ処理 | E-01 (221行目) | ○ |
| C-05 | _readConfiguration()で設定読み込み | E-01 (452行目) | ○ |
| C-06 | _renderStickyScroll()でレンダリング | E-01 (537行目) | ○ |
| C-07 | findScrollWidgetState()で状態計算 | E-01 (603行目) | ○ |
| C-08 | StickyScrollWidgetState.Emptyを使用 | E-01 (98行目) | ○ |
| C-09 | _maxStickyLinesでエディタ高さの25%制限 | E-01 (533行目) | ○ |
| C-10 | ClickLinkGestureでCtrl+クリック検出 | E-01 (248行目) | ○ |
| C-11 | goToDefinitionWithLocationでジャンプ | E-01 (404行目) | ○ |
| C-12 | FoldingControllerと連携 | E-01 (30行目 import) | ○ |
| C-13 | toggleCollapseStateでフォールディング操作 | E-01 (442行目) | ○ |
| C-14 | EditorContextKeys.stickyScrollFocusedでフォーカス状態管理 | E-01 (122行目) | ○ |
| C-15 | 関連パス:stickyScrollController.ts | E-01 | ○ |
| C-16 | 機能No.20がスティッキースクロール | E-04 | ○ |
| C-17 | 関連ディレクトリはsrc/vs/editor/contrib/stickyScroll | E-04 | ○ |
| C-18 | IEditorContributionを実装 | E-01 (50行目) | ○ |
| C-19 | IContextMenuServiceを使用 | E-01 (85行目) | ○ |
| C-20 | onDidChangeStickyScrollHeightイベント | E-01 (80行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、ソースコードとの整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] スティッキースクロールが表示されることを実機確認
- [ ] スティッキー行をクリックして該当行にジャンプできることを確認
- [ ] Shift+クリックでスコープ終了行にジャンプできることを確認
- [ ] フォールディングアイコンをクリックして折りたためることを確認
- [ ] Ctrl+クリックで定義へ移動できることを確認
- [ ] 設定でスティッキースクロールを無効にできることを確認
- [ ] 最大表示行数の設定が反映されることを確認
