---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 25
  claims_without_evidence: 3
confidence_derived: 0.89
---

# 根拠レポート: 22-検索.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：25 / 28、根拠なし：3
- 優先レビュー（高）
  1. **パフォーマンス目標値**：実測データの確認が必要
  2. **AI検索機能の詳細**：実装の完全性確認が必要
  3. **メモリ使用量目標**：推定値の妥当性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/contrib/search/browser/searchView.ts`
- E-02: `src/vs/workbench/contrib/search/common/search.ts`
- E-03: `src/vs/workbench/contrib/search/common/searchModel.ts` （推定）
- E-04: `src/vs/workbench/services/search/common/searchService.ts` （推定）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SearchViewがサイドバーに表示される | E-01 (行456-600) | ○ |
| C-02 | 正規表現検索をサポート | E-02 (IPatternInfo) | ○ |
| C-03 | 大文字小文字区別検索をサポート | E-02 (IPatternInfo) | ○ |
| C-04 | 単語単位検索をサポート | E-02 (IPatternInfo) | ○ |
| C-05 | 検索履歴機能の実装 | E-01 (行320-340) | ○ |
| C-06 | デバウンス処理（250ms） | E-01 (行306) | ○ |
| C-07 | SearchWidgetでの入力処理 | E-01 (行460-470) | ○ |
| C-08 | IncludePatternInputWidgetの存在 | E-01 (行513-527) | ○ |
| C-09 | ExcludePatternInputWidgetの存在 | E-01 (行533-546) | ○ |
| C-10 | 検索状態（SearchUIState）の定義 | E-02 (行218-224) | ○ |
| C-11 | 遅延検索状態（SlowSearch）の存在 | E-01 (行424-426) | ○ |
| C-12 | AITextSearchResultの存在 | E-01 (行572-580) | ○ |
| C-13 | 検索結果のツリー表示 | E-01 (行564) | ○ |
| C-14 | 置換機能の実装 | E-01 (行408-416) | ○ |
| C-15 | ファイルパターンフィルタリング | E-01 (行464-467) | ○ |
| C-16 | 開いているエディタのみ検索 | E-01 (行469, 522) | ○ |
| C-17 | WorkspaceSymbolProviderRegistry | E-02 (行36-62) | ○ |
| C-18 | extractRangeFromFilter関数 | E-02 (行159-216) | ○ |
| C-19 | 検索キャンセル機能 | E-01 (行544, 524) | ○ |
| C-20 | 検索結果のリフレッシュ機能 | E-01 (行346-348) | ○ |
| C-21 | ツリービューとリストビューの切り替え | E-01 (行357-364) | ○ |
| C-22 | 検索履歴のストレージ保存 | E-01 (行317-320) | ○ |
| C-23 | フォルダマッチによる結果グループ化 | E-02 (SearchResult構造) | ○ |
| C-24 | 検索クエリのワークスペース状態確認 | E-01 (行400-404) | ○ |
| C-25 | replaceSearchModel()メソッド | E-01 (行418-454) | ○ |
| C-26 | 入力レスポンス < 100ms | **根拠なし** | △ |
| C-27 | 初期結果表示 < 500ms | **根拠なし** | △ |
| C-28 | メモリ使用量 < 200MB（10万件） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス目標値は性能テスト結果から確認が必要
  - 候補：性能テストレポート / プロファイリングデータ / 設計仕様書
- AI検索機能の完全な実装詳細はaiTextSearchResult関連ファイルを確認
  - 候補：AITextSearchResult実装ファイル

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: パフォーマンス目標値は推定であり、実測結果と異なる可能性あり
- **0（低リスク）**: 検索機能のコアロジックは実装コードから正確に抽出

## 6) レビュアーチェックリスト（最小）
- [ ] SearchUIStateの状態遷移が設計書の記述と一致するか確認
- [ ] triggerQueryChange()のデバウンス処理が正しく記述されているか
- [ ] 検索履歴の保存・復元フローが実装と一致するか
- [ ] AI検索機能の実装状況を確認
- [ ] パフォーマンス目標値の妥当性を実測データで検証
