---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 26
  claims_with_evidence: 23
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート: 23-ソース管理.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：23 / 26、根拠なし：3
- 優先レビュー（高）
  1. **パフォーマンス目標値**：実測データの確認が必要
  2. **SCMサービス実装詳細**：scmService.tsの確認推奨
  3. **具体的なGit拡張連携**：拡張機能側の実装確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/contrib/scm/browser/scmViewPane.ts`
- E-02: `src/vs/workbench/contrib/scm/common/scm.ts` （推定）
- E-03: `src/vs/workbench/contrib/scm/common/scmService.ts` （推定）
- E-04: `src/vs/workbench/contrib/scm/browser/scmViewService.ts` （推定）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SCMViewPaneがサイドバーに表示される | E-01 (行10-15) | ○ |
| C-02 | ISCMRepository、ISCMResourceGroupインターフェース | E-01 (行14, 27) | ○ |
| C-03 | CodeEditorWidgetをコミット入力に使用 | E-01 (行44-45) | ○ |
| C-04 | WorkbenchCompressibleAsyncDataTreeでツリー表示 | E-01 (行28) | ○ |
| C-05 | TreeElement型定義（5種類） | E-01 (行115) | ○ |
| C-06 | processResourceFilterData関数 | E-01 (行117-165) | ○ |
| C-07 | ActionButtonRendererクラス | E-01 (行179-233) | ○ |
| C-08 | SCMTreeDragAndDropクラス | E-01 (行236-287) | ○ |
| C-09 | InputTemplateインターフェース | E-01 (行289-294) | ○ |
| C-10 | InputRendererクラス（行298-300） | E-01 (行296-300) | ○ |
| C-11 | ResourceLabelsの使用 | E-01 (行15) | ○ |
| C-12 | CountBadgeの使用 | E-01 (行16) | ○ |
| C-13 | ISCMServiceインターフェース | E-02 | ○ |
| C-14 | ISCMViewServiceインターフェース | E-01 (行14) | ○ |
| C-15 | ActionRunner、IActionの使用 | E-01 (行24) | ○ |
| C-16 | MenuItemAction、IMenuServiceの使用 | E-01 (行23) | ○ |
| C-17 | ドラッグ&ドロップでのURI取得 | E-01 (行239-245) | ○ |
| C-18 | fillEditorsDragDataの使用 | E-01 (行88, 250) | ○ |
| C-19 | CodeDataTransfersの使用 | E-01 (行90, 254) | ○ |
| C-20 | ThemeIconの使用 | E-01 (行67) | ○ |
| C-21 | InlineCompletionsControllerの使用 | E-01 (行84) | ○ |
| C-22 | PlaceholderTextContributionの使用 | E-01 (行106) | ○ |
| C-23 | AccessibilityVerbositySettingIdの使用 | E-01 (行108) | ○ |
| C-24 | 変更検出レスポンス < 200ms | **根拠なし** | △ |
| C-25 | コミット実行 < 1s | **根拠なし** | △ |
| C-26 | 差分表示 < 500ms | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス目標値は性能テスト結果から確認が必要
  - 候補：性能テストレポート / プロファイリングデータ
- SCMServiceの完全な実装詳細
  - 候補：`src/vs/workbench/contrib/scm/common/scmService.ts`
- Git拡張機能との具体的な連携方法
  - 候補：Git拡張機能のソースコード

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: パフォーマンス目標値は推定であり、実測結果と異なる可能性あり
- **0（低リスク）**: データ構造とインターフェースは実装コードから正確に抽出

## 6) レビュアーチェックリスト（最小）
- [ ] ISCMRepository、ISCMResourceGroupの定義が実装と一致するか確認
- [ ] SCMTreeDragAndDropの実装が設計書の記述と一致するか
- [ ] InputRendererの実装が正しく記述されているか
- [ ] パフォーマンス目標値の妥当性を実測データで検証
- [ ] SCMサービスのregisterSCMProvider実装を確認
