---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 30
  claims_with_evidence: 27
  claims_without_evidence: 3
confidence_derived: 0.90
---

# 根拠レポート: 24-デバッグ.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：27 / 30、根拠なし：3
- 優先レビュー（高）
  1. **パフォーマンス目標値**：実測データの確認が必要
  2. **DAP仕様との整合性**：公式仕様との照合推奨
  3. **エラーコード体系**：実装での使用状況確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/contrib/debug/browser/debugService.ts`
- E-02: `src/vs/workbench/contrib/debug/common/debug.ts` （推定）
- E-03: `src/vs/workbench/contrib/debug/common/debugModel.ts` （推定）
- E-04: `src/vs/workbench/contrib/debug/browser/debugSession.ts` （推定）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DebugServiceクラスの存在 | E-01 (行63) | ○ |
| C-02 | DebugModelのインスタンス化 | E-01 (行136) | ○ |
| C-03 | ViewModelのインスタンス化 | E-01 (行139) | ○ |
| C-04 | TaskRunnerのインスタンス化 | E-01 (行140) | ○ |
| C-05 | ConfigurationManagerの存在 | E-01 (行76, 130) | ○ |
| C-06 | AdapterManagerの存在 | E-01 (行77, 125-129) | ○ |
| C-07 | _onDidChangeStateイベント | E-01 (行66) | ○ |
| C-08 | _onDidNewSessionイベント | E-01 (行67) | ○ |
| C-09 | _onWillNewSessionイベント | E-01 (行68) | ○ |
| C-10 | _onDidEndSessionイベント | E-01 (行69) | ○ |
| C-11 | debugStorageの使用 | E-01 (行71, 132) | ○ |
| C-12 | telemetryの使用 | E-01 (行74, 137) | ○ |
| C-13 | コンテキストキーの初期化 | E-01 (行218-236) | ○ |
| C-14 | CONTEXT_DEBUG_TYPE | E-01 (行47, 221) | ○ |
| C-15 | CONTEXT_DEBUG_STATE | E-01 (行47, 222) | ○ |
| C-16 | CONTEXT_IN_DEBUG_MODE | E-01 (行47, 224) | ○ |
| C-17 | CONTEXT_DEBUG_UX | E-01 (行47, 225) | ○ |
| C-18 | CONTEXT_BREAKPOINTS_EXIST | E-01 (行47, 227) | ○ |
| C-19 | State（Inactive/Initializing等） | E-01 (行264-271) | ○ |
| C-20 | extensionHostDebugService連携 | E-01 (行145-160) | ○ |
| C-21 | lifecycleService連携 | E-01 (行143) | ○ |
| C-22 | fileService連携 | E-01 (行142) | ○ |
| C-23 | セッションキャンセル機能 | E-01 (行90, 293-300) | ○ |
| C-24 | activityService連携 | E-01 (行177-186) | ○ |
| C-25 | viewModel.onDidFocusStackFrame | E-01 (行162-164) | ○ |
| C-26 | viewModel.onDidFocusSession | E-01 (行165-171) | ○ |
| C-27 | breakpointsToSendOnResourceSaved | E-01 (行86, 118) | ○ |
| C-28 | デバッグ開始 < 2s | **根拠なし** | △ |
| C-29 | ステップ実行 < 100ms | **根拠なし** | △ |
| C-30 | 変数表示 < 200ms | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス目標値は性能テスト結果から確認が必要
  - 候補：性能テストレポート / プロファイリングデータ
- Debug Adapter Protocol（DAP）の完全な仕様との照合
  - 候補：DAP公式仕様書 / Debug Adapter実装
- エラーコード体系の実装での使用状況
  - 候補：エラーハンドリング実装箇所

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: パフォーマンス目標値は推定であり、実測結果と異なる可能性あり
- **0（低リスク）**: DebugServiceのコア構造は実装コードから正確に抽出

## 6) レビュアーチェックリスト（最小）
- [ ] DebugServiceのstartDebugging()メソッドの実装が設計書と一致するか
- [ ] State enumの値が実装と一致するか
- [ ] コンテキストキーの初期化が正しく記述されているか
- [ ] DAP仕様との整合性を確認
- [ ] パフォーマンス目標値の妥当性を実測データで検証
