---
generated_at: 2026-01-27 10:55:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート: 26-ターミナル.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **ITerminalInstanceの完全なインターフェース**：確認推奨
  2. **xterm.js統合の詳細**：実装確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/terminal/browser/terminalService.ts`
- E-02: `src/vs/workbench/contrib/terminal/browser/terminalInstance.ts` （推定）
- E-03: `src/vs/workbench/contrib/terminal/common/terminal.ts` （推定）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TerminalServiceクラスの存在 | E-01 (行66) | ○ |
| C-02 | _hostActiveTerminalsプロパティ | E-01 (行69) | ○ |
| C-03 | _detachedXtermsプロパティ | E-01 (行71) | ○ |
| C-04 | _backgroundedTerminalInstancesプロパティ | E-01 (行76) | ○ |
| C-05 | connectionStateプロパティ | E-01 (行88-89) | ○ |
| C-06 | whenConnectedプロパティ | E-01 (行91-92) | ○ |
| C-07 | instancesゲッター | E-01 (行97-99) | ○ |
| C-08 | foregroundInstancesゲッター | E-01 (行100-103) | ○ |
| C-09 | detachedInstancesゲッター | E-01 (行104-106) | ○ |
| C-10 | activeInstanceゲッター | E-01 (行115-127) | ○ |
| C-11 | onDidCreateInstanceイベント | E-01 (行129-130) | ○ |
| C-12 | onDidChangeInstanceDimensionsイベント | E-01 (行131-132) | ○ |
| C-13 | onDidDisposeInstanceイベント | E-01 (行141-142) | ○ |
| C-14 | onDidChangeActiveInstanceイベント | E-01 (行145-146) | ○ |
| C-15 | TerminalContextKeysの使用 | E-01 (行39, 221-225) | ○ |
| C-16 | ITerminalGroupServiceの使用 | E-01 (行32, 180) | ○ |
| C-17 | ITerminalEditorServiceの使用 | E-01 (行32, 179) | ○ |
| C-18 | ITerminalInstanceServiceの使用 | E-01 (行32, 181) | ○ |
| C-19 | ITerminalProfileServiceの使用 | E-01 (行38, 183) | ○ |
| C-20 | showProfileQuickPick()メソッド | E-01 (行240-278) | ○ |
| C-21 | _initializePrimaryBackend()メソッド | E-01 (行280-300) | ○ |
| C-22 | XtermTerminalの使用 | E-01 (行47) | ○ |
| C-23 | ITerminalInstanceの完全なインターフェース | **根拠不足** | △ |
| C-24 | IShellLaunchConfigの完全な定義 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- ITerminalInstanceインターフェースの完全な定義
  - 候補：`src/vs/workbench/contrib/terminal/browser/terminal.ts`
- IShellLaunchConfigの完全な定義
  - 候補：`src/vs/platform/terminal/common/terminal.ts`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: TerminalServiceのコア構造は実装から正確に抽出
- **1（中リスク）**: 一部のインターフェース定義は推定

## 6) レビュアーチェックリスト（最小）
- [ ] TerminalServiceの各プロパティが実装と一致するか
- [ ] createTerminal()の実装フローを確認
- [ ] ITerminalInstanceの完全な定義を確認
- [ ] xterm.js統合の実装を確認
