---
generated_at: 2026-01-27 11:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート: 27-アウトライン.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **IOutlineServiceの完全な実装**：サービスファイルの確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/outline/browser/outlinePane.ts`
- E-02: `src/vs/workbench/contrib/outline/browser/outlineViewState.ts` （推定）
- E-03: `src/vs/workbench/services/outline/browser/outline.ts` （推定）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OutlinePaneクラスの存在 | E-01 (行58) | ○ |
| C-02 | OutlinePane.Idの定義 | E-01 (行60) | ○ |
| C-03 | _disposablesプロパティ | E-01 (行62) | ○ |
| C-04 | _editorControlDisposablesプロパティ | E-01 (行64) | ○ |
| C-05 | _outlineViewStateプロパティ | E-01 (行66) | ○ |
| C-06 | _domNode、_message、_progressBar、_treeContainerプロパティ | E-01 (行70-74) | ○ |
| C-07 | _ctxFollowsCursor等のコンテキストキー | E-01 (行78-81, 102-107) | ○ |
| C-08 | IOutlineServiceの使用 | E-01 (行29, 85) | ○ |
| C-09 | OutlineViewStateの使用 | E-01 (行28, 66, 99) | ○ |
| C-10 | collapseAll()メソッド | E-01 (行168-170) | ○ |
| C-11 | expandAll()メソッド | E-01 (行172-174) | ○ |
| C-12 | renderBody()メソッド | E-01 (行133-159) | ○ |
| C-13 | layoutBody()メソッド | E-01 (行162-166) | ○ |
| C-14 | _handleEditorChanged()メソッド | E-01 (行201-212) | ○ |
| C-15 | _handleEditorControlChanged()メソッド | E-01 (行214-300) | ○ |
| C-16 | OutlineTreeSorterクラス | E-01 (行40-56) | ○ |
| C-17 | OutlineSortOrder enum（ByPosition/ByName/ByKind） | E-01 (行36, 48-54) | ○ |
| C-18 | WorkbenchDataTreeの使用 | E-01 (行18, 255-272) | ○ |
| C-19 | CancellationTokenSourceの使用 | E-01 (行31, 235-236) | ○ |
| C-20 | ProgressBarの使用 | E-01 (行8, 142) | ○ |
| C-21 | ctxFocusedコンテキストキー | E-01 (行36, 274) | ○ |
| C-22 | IOutlineServiceの完全な実装 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- IOutlineServiceの完全な実装詳細
  - 候補：`src/vs/workbench/services/outline/browser/outline.ts`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: OutlinePaneのコア構造は実装から正確に抽出

## 6) レビュアーチェックリスト（最小）
- [ ] OutlinePaneの各メソッドが実装と一致するか
- [ ] OutlineTreeSorterのソートロジックを確認
- [ ] コンテキストキーの初期化と使用を確認
- [ ] IOutlineServiceの実装を確認
