---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 21
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：3-コード補完（IntelliSense）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：21 / 24、根拠なし：3
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**：根拠不足
  2. **LSP連携の詳細実装**：根拠不足
  3. **候補数上限の設定**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/editor/contrib/suggest/browser/suggest.ts` - CompletionItem、provideSuggestionItems
- E-02: `src/vs/editor/contrib/suggest/browser/suggestController.ts` - SuggestController
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能関連情報
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SuggestControllerがID 'editor.contrib.suggestController'で登録 | E-02 (116行目) | ○ |
| C-02 | SuggestModelを使用して補完モデル管理 | E-02 (148行目) | ○ |
| C-03 | SuggestWidgetで候補表示 | E-02 (161-163行目) | ○ |
| C-04 | onDidSelectでinsertSuggestion呼び出し | E-02 (166行目) | ○ |
| C-05 | CompletionItemがposition, completion, container, providerを保持 | E-01 (80-85行目) | ○ |
| C-06 | editStart, editInsertEnd, editReplaceEndで範囲管理 | E-01 (52-54行目) | ○ |
| C-07 | FuzzyScoreでスコア計算 | E-01 (68行目) | ○ |
| C-08 | provideSuggestionItems関数でプロバイダ問い合わせ | E-01 (214-221行目) | ○ |
| C-09 | CompletionOptionsでスニペットソート順設定可能 | E-01 (169-180行目) | ○ |
| C-10 | SnippetSortOrderにTop/Inline/Bottomが存在 | E-01 (165-167行目) | ○ |
| C-11 | showDeprecatedオプションでDeprecated候補表示制御 | E-01 (178行目, 243行目) | ○ |
| C-12 | kindFilterで候補種類フィルタリング | E-01 (175行目, 241行目) | ○ |
| C-13 | Contextに複数のコンテキストキー定義 | E-01 (32-43行目) | ○ |
| C-14 | テキストエディタが主画面として関連 | E-03 (31行目) | ○ |
| C-15 | 機能の備考にsrc/vs/editor/contrib/suggestが記載 | E-04 (4行目) | ○ |
| C-16 | CompletionItemModelでitems, needsClipboard, durations管理 | E-01 (205-212行目) | ○ |
| C-17 | CompletionDurationsでプロバイダごとのパフォーマンス計測 | E-01 (194-203行目) | ○ |
| C-18 | LineSuffixクラスで行末デコレーション管理 | E-02 (54-104行目) | ○ |
| C-19 | InsertFlagsでNoBeforeUndoStop等のフラグ定義 | E-02 (106-112行目) | ○ |
| C-20 | selectionModeにnever/always/whenTriggerCharacter/whenQuickSuggestion | E-02 (261-272行目) | ○ |
| C-21 | resolveCompletionItemで候補詳細を遅延取得 | E-01 (124-127行目, 140-162行目) | ○ |
| C-22 | 補完候補表示100ms以内 | **根拠なし** | △ |
| C-23 | LSP連携の詳細実装 | **根拠なし** | △ |
| C-24 | 候補数上限1000件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値はコード内に明示的記載がない
  - 候補：設定ファイル / ベンチマークテスト
- LSP連携の詳細実装は別モジュール
  - 候補：`src/vs/workbench/api` / 言語サーバークライアント
- 候補数上限の設定箇所の確認が必要
  - 候補：CompletionModel / 設定オプション

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - SuggestController/CompletionItemの構造はコードと一致
- 0: 低リスク - プロバイダ呼び出しフローはコードで検証可能
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] SuggestController.IDが正しく登録されているか確認
- [ ] provideSuggestionItems関数のプロバイダ呼び出し順序を確認
- [ ] CompletionItemの範囲正規化ロジックを確認
- [ ] selectionModeの4種類の挙動を確認
- [ ] insertSuggestionでの補完テキスト挿入処理を確認
