---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：31-コマンドパレット機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**: 具体的な数値の根拠なし
  2. **履歴保存形式**: StorageServiceへの保存形式の詳細確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/contrib/quickaccess/browser/commandsQuickAccess.ts`
- E-02: `src/vs/workbench/contrib/quickaccess/browser/quickAccess.contribution.ts`
- E-03: `src/vs/platform/quickinput/browser/commandsQuickAccess.ts`
- E-04: `src/vs/platform/quickinput/common/quickInput.ts`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | キーボードショートカット Ctrl+Shift+P / F1 で起動 | E-01 (278-285行目) | ○ |
| C-02 | プレフィックス ">" でコマンドパレットモードを識別 | E-02 (42-48行目), E-01 (292行目) | ○ |
| C-03 | 拡張機能登録完了を最大800ms待機 | E-01 (91行目) | ○ |
| C-04 | MenuServiceからCommandPaletteメニューのコマンドを取得 | E-01 (229行目) | ○ |
| C-05 | AI検索は200msのデバウンス後に実行 | E-01 (47行目, 165行目) | ○ |
| C-06 | AI関連情報サービスによる自然言語検索機能 | E-01 (200-224行目) | ○ |
| C-07 | コマンド実行履歴の管理と優先表示 | E-03 (CommandsHistory クラス) | ○ |
| C-08 | コンテキストキーによるコマンド表示制御 | E-01 (228行目, 259行目) | ○ |
| C-09 | ShowAllCommandsAction.ID = 'workbench.action.showCommands' | E-01 (275行目) | ○ |
| C-10 | キーバインド設定画面への遷移機能（歯車ボタン） | E-01 (133-140行目) | ○ |
| C-11 | 関連画面No.47（コマンドパレット）との対応 | E-05 (99-100行目) | ○ |
| C-12 | ChatAgentServiceとの連携機能 | E-01 (173-174行目, 181-194行目) | ○ |
| C-13 | AI検索の最大結果数は5件 | E-01 (46行目) | ○ |
| C-14 | ClearCommandHistoryActionの存在 | E-01 (296-329行目) | ○ |
| C-15 | 設定 workbench.commandPalette.preserveInput | E-01 (96-104行目) | ○ |
| C-16 | グローバルコマンドとエディタコマンドの統合 | E-01 (128-131行目) | ○ |
| C-17 | パフォーマンス要件（表示100ms以内等） | **根拠なし** | △ |
| C-18 | 履歴のJSON形式での保存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値は設計ドキュメントやコード内のコメントでは確認できず
  - 候補：パフォーマンステスト仕様書 / 製品要件定義書 / コードベンチマーク結果
- StorageServiceへの履歴保存の詳細フォーマット
  - 候補：CommandsHistoryクラスの実装詳細 / StorageServiceのスキーマ定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コアロジック（コマンド取得・フィルタリング）は十分な根拠あり
- 1: 中リスク - パフォーマンス要件は推定値のため、実測値との乖離確認が必要
- 0: 低リスク - AI検索機能は実験的機能であり、設定で無効化可能

## 6) レビュアーチェックリスト（最小）
- [ ] CommandsQuickAccessProvider.getCommandPicksの実装がフローチャートと一致するか
- [ ] 拡張機能待機のタイムアウト値（800ms）が適切か
- [ ] AI検索デバウンス値（200ms）がUX要件を満たすか
- [ ] 関連画面マッピング（No.47）が最新の画面一覧と整合するか
- [ ] パフォーマンス要件の数値を実測データで検証
