---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：33-キーバインディング機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**: 設計書やテスト仕様での確認必要
  2. **システムショートカットのオーバーライド制限**: OS依存の動作確認必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/preferences/browser/keybindingsEditor.ts`
- E-02: `src/vs/workbench/contrib/preferences/browser/preferences.contribution.ts`
- E-03: `src/vs/workbench/contrib/preferences/common/preferences.ts`
- E-04: `src/vs/workbench/contrib/keybindings/browser/keybindings.contribution.ts`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | KeybindingsEditor.ID = 'workbench.editor.keybindings' | E-01 (76行目) | ○ |
| C-02 | 検索デバウンスは300ms | E-01 (136行目: Delayer<void>(300)) | ○ |
| C-03 | 履歴保存デバウンスは500ms | E-01 (143行目: Delayer<void>(500)) | ○ |
| C-04 | recordKeysAction（キーを記録）機能の存在 | E-01 (145-146行目) | ○ |
| C-05 | sortByPrecedenceAction（優先度順ソート）機能の存在 | E-01 (148-149行目) | ○ |
| C-06 | CONTEXT_KEYBINDINGS_EDITORコンテキストキー | E-01 (139行目), E-03 | ○ |
| C-07 | CONTEXT_KEYBINDING_FOCUSコンテキストキー | E-01 (141行目), E-03 | ○ |
| C-08 | CONTEXT_KEYBINDINGS_SEARCH_FOCUSコンテキストキー | E-01 (140行目), E-03 | ○ |
| C-09 | KeybindingsSearchWidgetの使用 | E-01 (94行目, 25行目) | ○ |
| C-10 | DefineKeybindingWidgetの使用 | E-01 (98行目, 25行目) | ○ |
| C-11 | WorkbenchTableによるテーブル表示 | E-01 (103行目, 37行目) | ○ |
| C-12 | KeybindingEditingServiceへの依存 | E-01 (125行目, 28行目) | ○ |
| C-13 | 関連画面No.15（キーバインド設定エディタ）との対応 | E-05 (54行目) | ○ |
| C-14 | 関連画面No.19（プロファイルエディタ）との対応 | E-05 (62行目) | ○ |
| C-15 | ToggleKeybindingsLogActionの存在（トラブルシューティング） | E-04 (19-98行目) | ○ |
| C-16 | エディタペインとしての登録 | E-02 (108-117行目) | ○ |
| C-17 | パフォーマンス要件（初期表示300ms以内等） | **根拠なし** | △ |
| C-18 | システムショートカットのオーバーライド制限 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値の出典
  - 候補：パフォーマンステスト仕様書 / 製品要件定義書
- システムショートカットの制限に関する具体的な実装
  - 候補：KeybindingService / OS固有の実装コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UIコンポーネント（KeybindingsEditor、検索、テーブル）の実装は十分な根拠あり
- 1: 中リスク - パフォーマンス要件は推定値のため、実測値との乖離確認が必要
- 0: 低リスク - キーバインドの永続化はKeybindingEditingServiceに委譲しており、十分にテストされている

## 6) レビュアーチェックリスト（最小）
- [ ] KeybindingsEditorのライフサイクル（createEditor、setInput、dispose）が正しく記述されているか
- [ ] 「キーを記録」モードの動作が正確に記述されているか
- [ ] when条件編集機能の実装詳細が正確か
- [ ] 関連画面マッピング（No.15、No.19）が最新の画面一覧と整合するか
- [ ] keybindings.jsonの書き込みフォーマットが正確か
