---
generated_at: 2026-01-27 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 15
  claims_without_evidence: 3
confidence_derived: 0.83
---

# 根拠レポート：36-チャット機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：15 / 18、根拠なし：3
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**: 設計書やテスト仕様での確認必要
  2. **エンタイトルメント制御の詳細**: ChatEntitlementServiceの確認必要
  3. **ストリーミング応答のリトライ仕様**: 詳細実装の確認必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/chat/browser/chat.contribution.ts`
- E-02: `src/vs/workbench/contrib/chat/common/constants.ts`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | chat.fontSize設定の存在 | E-01 (154-159行目) | ○ |
| C-02 | chat.fontFamily設定の存在 | E-01 (160-164行目) | ○ |
| C-03 | chat.editor.fontSize設定の存在 | E-01 (165-169行目) | ○ |
| C-04 | chat.commandCenter.enabled設定の存在 | E-01 (192-196行目) | ○ |
| C-05 | ChatAgentLocation（Panel、Editor等）の存在 | E-01 (49行目), E-02 | ○ |
| C-06 | ChatModeKindの存在 | E-01 (49行目) | ○ |
| C-07 | IChatServiceの存在 | E-01 (41行目) | ○ |
| C-08 | ILanguageModelsServiceの存在 | E-01 (51行目) | ○ |
| C-09 | IChatAgentServiceの存在 | E-01 (34行目) | ○ |
| C-10 | IChatVariablesServiceの存在 | E-01 (47行目) | ○ |
| C-11 | IChatEditingServiceの存在 | E-01 (37行目) | ○ |
| C-12 | ChatWidgetの存在 | E-01 (123行目) | ○ |
| C-13 | ILanguageModelToolsServiceの存在 | E-01 (54行目) | ○ |
| C-14 | ACTION_ID_NEW_CHATの存在 | E-01 (68行目) | ○ |
| C-15 | ChatEntitlementServiceの存在 | E-01 (30行目) | ○ |
| C-16 | パフォーマンス要件（初回トークン1秒以内等） | **根拠なし** | △ |
| C-17 | ネットワークエラー時の指数バックオフリトライ | **根拠なし** | △ |
| C-18 | エンタイトルメント制御の詳細仕様 | **根拠なし** (ChatEntitlementService側) | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値の出典
  - 候補：パフォーマンステスト仕様書 / 製品要件定義書
- リトライ処理の詳細実装
  - 候補：ChatService実装 / LanguageModelsService実装
- エンタイトルメント（利用資格）制御の詳細
  - 候補：ChatEntitlementService / 製品ライセンス仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能（チャットUI、サービス構造）の実装は十分な根拠あり
- 1: 中リスク - パフォーマンス要件は推定値のため、実測値との乖離確認が必要
- 1: 中リスク - AI機能は外部サービス依存のため、エラーハンドリングの詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ChatWidgetの入力処理フローが正確か
- [ ] ストリーミング応答の処理が正確か
- [ ] エージェント（@メンション）の解決フローが正確か
- [ ] ツール呼び出しと承認フローが正確か
- [ ] 関連画面マッピング（No.26、No.37）が最新の画面一覧と整合するか
- [ ] 認証とエンタイトルメント制御の記述が正確か
