---
generated_at: 2026-01-27 11:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：37-インラインチャット機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**: 設計書やテスト仕様での確認必要
  2. **InlineChatController.IDの確認**: 実装での正確なID確認必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/inlineChat/browser/inlineChat.contribution.ts`
- E-02: `src/vs/workbench/contrib/inlineChat/common/inlineChat.ts`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InlineChatControllerのエディタコントリビューション登録 | E-01 (27行目) | ○ |
| C-02 | EditorContributionInstantiation.Eager | E-01 (27行目) | ○ |
| C-03 | KeepSessionAction2の登録 | E-01 (29行目) | ○ |
| C-04 | UndoAndCloseSessionAction2の登録 | E-01 (30行目) | ○ |
| C-05 | InlineChatSessionServiceImplのシングルトン登録 | E-01 (34行目) | ○ |
| C-06 | CTX_INLINE_CHAT_EDITINGコンテキストキー | E-01 (10行目), E-02 | ○ |
| C-07 | CTX_INLINE_CHAT_REQUEST_IN_PROGRESSコンテキストキー | E-01 (10行目), E-02 | ○ |
| C-08 | CTX_INLINE_CHAT_V1_ENABLEDコンテキストキー | E-01 (10行目), E-02 | ○ |
| C-09 | MENU_INLINE_CHAT_WIDGET_STATUSの存在 | E-01 (10行目, 68-84行目) | ○ |
| C-10 | ChatSubmitAction.IDの使用 | E-01 (42行目, 57行目) | ○ |
| C-11 | CancelAction.IDの使用 | E-01 (74行目) | ○ |
| C-12 | InlineChatNotebookContributionの登録 | E-01 (93行目) | ○ |
| C-13 | パフォーマンス要件（ウィジェット表示100ms以内等） | **根拠なし** | △ |
| C-14 | InlineChatController.ID = 'editor.contrib.inlineChat' | **根拠なし** (inlineChatController.ts側) | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値の出典
  - 候補：パフォーマンステスト仕様書 / 製品要件定義書
- InlineChatControllerの詳細実装
  - 候補：inlineChatController.ts

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能（アクション、セッション管理）の実装は十分な根拠あり
- 1: 中リスク - パフォーマンス要件は推定値のため、実測値との乖離確認が必要
- 0: 低リスク - チャットサービスとの連携はChatSubmitActionを再利用しており安定

## 6) レビュアーチェックリスト（最小）
- [ ] InlineChatControllerの起動フローが正確か
- [ ] 編集モードと生成モードの切り替え条件が正確か
- [ ] KeepSessionActionとUndoAndCloseSessionActionの動作が正確か
- [ ] ノートブック統合（InlineChatNotebookContribution）の動作が正確か
- [ ] コンテキストキーの状態遷移が正確か
