---
generated_at: 2026-01-27 11:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：38-マージエディタ機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**: 設計書やテスト仕様での確認必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/mergeEditor/browser/mergeEditor.contribution.ts`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MergeEditorのエディタペイン登録 | E-01 (29-38行目) | ○ |
| C-02 | MergeEditorSerializer登録 | E-01 (40-43行目) | ○ |
| C-03 | mergeEditor.diffAlgorithm設定（legacy/advanced） | E-01 (47-54行目) | ○ |
| C-04 | advanced差分アルゴリズムがデフォルト | E-01 (49行目) | ○ |
| C-05 | mergeEditor.showDeletionMarkers設定 | E-01 (56-60行目) | ○ |
| C-06 | OpenMergeEditorアクションの登録 | E-01 (67行目) | ○ |
| C-07 | AcceptMergeアクションの登録 | E-01 (88行目) | ○ |
| C-08 | GoToNextUnhandledConflictアクションの登録 | E-01 (74行目) | ○ |
| C-09 | GoToPreviousUnhandledConflictアクションの登録 | E-01 (75行目) | ○ |
| C-10 | AcceptAllInput1/AcceptAllInput2アクションの登録 | E-01 (83-84行目) | ○ |
| C-11 | SetMixedLayout/SetColumnLayoutアクションの登録 | E-01 (65-66行目) | ○ |
| C-12 | MergeEditorOpenHandlerContributionの登録 | E-01 (99-101行目) | ○ |
| C-13 | MergeEditorAccessibilityHelpProviderの登録 | E-01 (105行目) | ○ |
| C-14 | パフォーマンス要件（表示1秒以内、アクション100ms以内等） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値の出典
  - 候補：パフォーマンステスト仕様書 / 製品要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能（エディタ登録、アクション）の実装は十分な根拠あり
- 0: 低リスク - 設定スキーマ（diffAlgorithm、showDeletionMarkers）は明確に定義されている
- 0: 低リスク - 各種アクションが網羅的に登録されている

## 6) レビュアーチェックリスト（最小）
- [ ] 4ペインレイアウトの構成が正確か
- [ ] 差分アルゴリズム（legacy/advanced）の切り替えが正確か
- [ ] 競合解決アクション（AcceptInput1/2、AcceptCombination）の動作が正確か
- [ ] マージ完了（AcceptMerge）のフローが正確か
- [ ] 未解決競合がある場合の警告動作が正確か
