---
generated_at: 2026-01-27 11:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：39-差分エディタ機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**: 設計書やテスト仕様での確認必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/multiDiffEditor/browser/multiDiffEditor.contribution.ts`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GoToFileActionの登録 | E-01 (20行目) | ○ |
| C-02 | GoToNextChangeActionの登録 | E-01 (21行目) | ○ |
| C-03 | GoToPreviousChangeActionの登録 | E-01 (22行目) | ○ |
| C-04 | CollapseAllActionの登録 | E-01 (23行目) | ○ |
| C-05 | ExpandAllActionの登録 | E-01 (24行目) | ○ |
| C-06 | MultiDiffSourceResolverServiceのシングルトン登録 | E-01 (27行目) | ○ |
| C-07 | MultiDiffEditorResolverContributionの登録 | E-01 (30行目) | ○ |
| C-08 | MultiDiffEditorのエディタペイン登録 | E-01 (32-36行目) | ○ |
| C-09 | MultiDiffEditorSerializerの登録 | E-01 (38-39行目) | ○ |
| C-10 | OpenScmGroupActionの登録 | E-01 (42行目) | ○ |
| C-11 | ScmMultiDiffSourceResolverContributionの登録 | E-01 (43行目) | ○ |
| C-12 | パフォーマンス要件（表示1秒以内、ナビゲーション100ms以内等） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値の出典
  - 候補：パフォーマンステスト仕様書 / 製品要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能（アクション、サービス登録）の実装は十分な根拠あり
- 0: 低リスク - SCM統合（OpenScmGroupAction、ScmMultiDiffSourceResolverContribution）が明確に登録されている
- 0: 低リスク - エディタペインとシリアライザーが正しく登録されている

## 6) レビュアーチェックリスト（最小）
- [ ] マルチ差分ビューのレイアウトが正確か
- [ ] 差分ソース解決（MultiDiffSourceResolverService）の動作が正確か
- [ ] ナビゲーションアクション（GoToNext/Previous）の動作が正確か
- [ ] SCM統合（OpenScmGroupAction）の動作が正確か
- [ ] 展開/折りたたみ機能の動作が正確か
