---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：4-括弧マッチング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（10ms以内）**：根拠不足
  2. **言語設定括弧定義の詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/editor/contrib/bracketMatching/browser/bracketMatching.ts` - BracketMatchingController
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能関連情報
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BracketMatchingControllerがID 'editor.contrib.bracketMatchingController'で登録 | E-01 (116行目) | ○ |
| C-02 | JumpToBracketActionが'editor.action.jumpToBracket'IDで登録 | E-01 (32行目) | ○ |
| C-03 | SelectToBracketActionが'editor.action.selectToBracket'IDで登録 | E-01 (51行目) | ○ |
| C-04 | RemoveBracketsActionが'editor.action.removeBrackets'IDで登録 | E-01 (84行目) | ○ |
| C-05 | Brackets型が[Range, Range]タプル | E-01 (101行目) | ○ |
| C-06 | BracketsDataがposition, brackets, optionsを保持 | E-01 (103-112行目) | ○ |
| C-07 | matchBracketsオプションで'never'/'near'/'always'を選択 | E-01 (128行目, 139行目) | ○ |
| C-08 | RunOnceSchedulerで50ms遅延実行 | E-01 (138行目) | ○ |
| C-09 | onDidChangeCursorPositionでカーソル位置変更を監視 | E-01 (142-151行目) | ○ |
| C-10 | model.bracketPairs.matchBracket()で括弧マッチング | E-01 (192行目) | ○ |
| C-11 | オーバービュールーラーにマーカー表示 | E-01 (27行目) | ○ |
| C-12 | テキストエディタが主画面として関連 | E-02 (32行目) | ○ |
| C-13 | 機能の備考にsrc/vs/editor/contrib/bracketMatchingが記載 | E-03 (5行目) | ○ |
| C-14 | selectBracketsパラメータで括弧自体を選択に含めるか制御 | E-01 (73-77行目) | ○ |
| C-15 | Ctrl+Shift+Backslashでジャンプ | E-01 (37行目) | ○ |
| C-16 | Ctrl+Alt+Backspaceで括弧削除 | E-01 (89行目) | ○ |
| C-17 | マッチング処理10ms以内 | **根拠なし** | △ |
| C-18 | 言語設定括弧定義の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値はコード内に明示的記載がない
  - 候補：ベンチマークテスト
- 言語設定の括弧定義の詳細は言語設定モジュールにある
  - 候補：`src/vs/editor/common/languages/languageConfiguration.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラ構造はコードと一致
- 0: 低リスク - アクションIDとキーバインドはコードで確認可能
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] BracketMatchingController.IDが正しく登録されているか確認
- [ ] matchBracketsオプションの3種類のモードの挙動を確認
- [ ] 50ms遅延実行のスケジューラ動作を確認
- [ ] model.bracketPairs.matchBracket()の戻り値を確認
- [ ] 各アクションのキーバインドを確認
