---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：40-タスク機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**: 設計書やテスト仕様での確認必要
  2. **ワークスペーストラスト制御の詳細**: 詳細実装の確認必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/tasks/browser/task.contribution.ts`
- E-02: `src/vs/workbench/contrib/tasks/common/tasks.ts`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RunAutomaticTasksの登録 | E-01 (49行目) | ○ |
| C-02 | ManageAutomaticTaskRunningのアクション登録 | E-01 (51行目) | ○ |
| C-03 | TaskStatusBarContributionsクラスの存在 | E-01 (61-161行目) | ○ |
| C-04 | TASK_RUNNING_STATEコンテキストキー | E-01 (23行目), E-02 | ○ |
| C-05 | TASK_TERMINAL_ACTIVEコンテキストキー | E-01 (23行目), E-02 | ○ |
| C-06 | TaskGroup.Build、TaskGroup.Testの存在 | E-01 (23行目), E-02 | ○ |
| C-07 | TaskEventKindの存在 | E-01 (23行目), E-02 | ○ |
| C-08 | MenubarTerminalMenuへのタスクメニュー追加 | E-01 (165-200行目) | ○ |
| C-09 | workbench.action.tasks.runTaskコマンド | E-01 (169行目) | ○ |
| C-10 | workbench.action.tasks.buildコマンド | E-01 (179行目) | ○ |
| C-11 | workbench.action.tasks.showTasksコマンド | E-01 (190行目) | ○ |
| C-12 | TaskExecutionSupportedContextの使用 | E-01 (58行目, 172行目等) | ○ |
| C-13 | TasksQuickAccessProviderの存在 | E-01 (37行目) | ○ |
| C-14 | ProblemMatcherRegistryの存在 | E-01 (13行目) | ○ |
| C-15 | パフォーマンス要件（タスク一覧500ms以内等） | **根拠なし** | △ |
| C-16 | ワークスペーストラスト制御の詳細実装 | **根拠なし** (runAutomaticTasks側) | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値の出典
  - 候補：パフォーマンステスト仕様書 / 製品要件定義書
- ワークスペーストラスト制御の詳細実装
  - 候補：runAutomaticTasks.ts / WorkspaceTrustService

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能（タスク登録、メニュー、ステータスバー）の実装は十分な根拠あり
- 1: 中リスク - パフォーマンス要件は推定値のため、実測値との乖離確認が必要
- 0: 低リスク - 問題マッチャーの登録と使用は明確に定義されている

## 6) レビュアーチェックリスト（最小）
- [ ] タスク定義（tasks.json）のスキーマが正確か
- [ ] タスク実行フロー（ターミナル作成、コマンド実行）が正確か
- [ ] 問題マッチャーの動作（正規表現パース、問題パネル追加）が正確か
- [ ] ステータスバー表示（実行中タスク数）が正確か
- [ ] 自動タスク実行とワークスペーストラストの関係が正確か
