---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：42-Webビュー機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **Service Workerバージョン番号**：ハードコードされた値の最新性確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/contrib/webview/browser/webview.ts` (IWebviewService、IWebview インターフェース)
- E-02: `src/vs/workbench/contrib/webview/browser/webviewService.ts` (WebviewService 実装)
- E-03: `src/vs/workbench/contrib/webview/browser/webviewElement.ts` (WebviewElement 実装)
- E-04: `src/vs/workbench/contrib/webview/browser/overlayWebview.ts` (OverlayWebview 実装)
- E-05: `src/vs/workbench/contrib/webview/browser/resourceLoading.ts` (リソース読み込み)
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` (機能定義)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IWebviewServiceがwebview.tsで定義 | E-01 (38行目) | ○ |
| C-02 | createWebviewElement()でWebviewElement生成 | E-02 (46-50行目) | ○ |
| C-03 | createWebviewOverlay()でOverlayWebview生成 | E-02 (52-56行目) | ○ |
| C-04 | WebviewContentPurposeに4種類の用途 | E-01 (84-89行目) | ○ |
| C-05 | WebviewOptionsにenableFindWidget等のオプション | E-01 (93-109行目) | ○ |
| C-06 | WebviewContentOptionsにallowScripts等 | E-01 (111-143行目) | ○ |
| C-07 | IWebviewにsetHtml/setTitle/postMessage等のメソッド | E-01 (181-274行目) | ○ |
| C-08 | IOverlayWebviewにclaim/release/layoutWebviewOverElement | E-01 (302-341行目) | ○ |
| C-09 | WebviewOriginStoreでオリジン管理 | E-01 (349-379行目) | ○ |
| C-10 | areWebviewContentOptionsEqual()でオプション比較 | E-01 (148-157行目) | ○ |
| C-11 | generateUuid()でオリジン生成 | E-01 (370行目) | ○ |
| C-12 | StorageScope.APPLICATIONでオリジン永続化 | E-01 (359行目) | ○ |
| C-13 | WebviewElementがiframeを生成 | E-03 (77行目, 101行目) | ○ |
| C-14 | MessagePortでメッセージング | E-03 (139行目) | ○ |
| C-15 | フォーカスイベントの50msスロットリング | E-03 (134行目) | ○ |
| C-16 | WebviewThemeDataProviderでテーマ連携 | E-02 (17行目, 23行目) | ○ |
| C-17 | onDidFocus/onDidBlurイベント | E-01 (225-226行目) | ○ |
| C-18 | onDidClickLinkイベント | E-01 (233行目) | ○ |
| C-19 | onFatalError/onMissingCspイベント | E-01 (249-250行目) | ○ |
| C-20 | intrinsicContentSizeプロパティ | E-01 (244行目), E-03 (145行目) | ○ |
| C-21 | WebviewPortMappingManagerでポートマッピング | E-03 (126行目, 182-186行目) | ○ |
| C-22 | registerNewWebview()でイベント監視登録 | E-02 (58-79行目) | ○ |
| C-23 | KEYBINDING_CONTEXT_WEBVIEW_FIND_WIDGET_VISIBLE | E-01 (26行目) | ○ |
| C-24 | Service Workerバージョン4 | E-03 (99行目) | ○ |
| C-25 | Service Workerバージョンの最新性 | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- **Service Workerバージョンの最新性確認**
  - webviewElement.tsの99行目で`_expectedServiceWorkerVersion = 4`とハードコードされている
  - 実際のservice-worker.jsファイルとの整合性確認が必要
  - 候補：service-worker.js / ビルドスクリプト

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: インターフェース定義、データ構造
- **0（低リスク）**: 処理フロー、イベント定義
- **1（中リスク）**: Service Workerバージョン（ハードコード値の同期が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] IWebviewServiceの主要メソッドが網羅されているか確認
- [ ] WebviewOptionsとWebviewContentOptionsの全項目が記載されているか確認
- [ ] セキュリティ関連の設定（CSP、sandbox、localResourceRoots）が正確か確認
- [ ] Service Workerのバージョンがservice-worker.jsと一致しているか確認
- [ ] Electron環境とWeb環境の差異が適切に記述されているか確認
