---
generated_at: 2026-01-27 11:00:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：43-コメント機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の500msデバウンス**：ストレージイベントのデバウンス値の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/contrib/comments/browser/commentService.ts` (CommentService、ICommentService)
- E-02: `src/vs/workbench/contrib/comments/browser/commentsModel.ts` (CommentsModel)
- E-03: `src/vs/workbench/contrib/comments/common/commentModel.ts` (ICommentThreadChangedEvent)
- E-04: `src/vs/workbench/contrib/comments/common/commentContextKeys.ts` (CommentContextKeys)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (画面マッピング)
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` (機能定義)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ICommentServiceがcommentService.tsで定義 | E-01 (27行目) | ○ |
| C-02 | ICommentControllerインターフェース定義 | E-01 (56-75行目) | ○ |
| C-03 | ICommentInfo/INotebookCommentInfo型定義 | E-01 (34-44行目) | ○ |
| C-04 | registerCommentController()でコントローラー登録 | E-01 (368-371行目) | ○ |
| C-05 | unregisterCommentController()でコントローラー解除 | E-01 (373-381行目) | ○ |
| C-06 | getDocumentComments()でコメント取得 | E-01 (465-490行目) | ○ |
| C-07 | getNotebookComments()でノートブックコメント取得 | E-01 (492-503行目) | ○ |
| C-08 | toggleReaction()でリアクション切替 | E-01 (445-453行目) | ○ |
| C-09 | Zenモード連動の実装 | E-01 (273-283行目) | ○ |
| C-10 | comments.visible設定との連動 | E-01 (264-271行目, 285-287行目) | ○ |
| C-11 | Continue On Comments機能 | E-01 (124行目, 177-178行目, 505-532行目) | ○ |
| C-12 | StorageScope.WORKSPACEでの永続化 | E-01 (520行目) | ○ |
| C-13 | vscodeSourceControlスキームの除外 | E-01 (241-243行目) | ○ |
| C-14 | _workspaceHasCommenting コンテキストキー | E-01 (174行目, 198行目) | ○ |
| C-15 | _commentingEnabled コンテキストキー | E-01 (175行目, 199行目) | ○ |
| C-16 | CommentMenusの管理 | E-01 (172行目, 412-420行目) | ○ |
| C-17 | CommentsModelでモデル管理 | E-01 (180-181行目) | ○ |
| C-18 | resourceHasCommentingRanges()の実装 | E-01 (551-553行目) | ○ |
| C-19 | hasReactionHandler()の実装 | E-01 (455-463行目) | ○ |
| C-20 | setCurrentCommentThread/setActiveEditingCommentThread | E-01 (305-315行目) | ○ |
| C-21 | onDidUpdateCommentThreadsイベント | E-01 (141-142行目) | ○ |
| C-22 | onDidChangeCommentingEnabledイベント | E-01 (156-157行目) | ○ |
| C-23 | ストレージイベントの500msデバウンス | E-01 (202行目) | ○ |
| C-24 | 画面No.32 コメントビュー | E-05 (83行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の検証**
  - E-01の202行目で500msのデバウンスを確認済み
  - 他のパフォーマンス最適化（並列問い合わせ等）の詳細な検証が追加で必要
  - 候補：パフォーマンステスト / プロファイリング結果

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: インターフェース定義、イベント定義
- **0（低リスク）**: 処理フロー、ビジネスルール
- **0（低リスク）**: ストレージ操作

## 6) レビュアーチェックリスト（最小）
- [ ] ICommentServiceの主要メソッドが網羅されているか確認
- [ ] ICommentControllerの全メンバーが記載されているか確認
- [ ] Continue On Comments機能の挙動が正確か確認
- [ ] Zenモード連動の挙動が正確か確認
- [ ] 画面マッピング（No.32）が最新か確認
