---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：44-ローカル履歴機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。追加確認が必要な項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/contrib/localHistory/browser/localHistory.ts` (定数、アイコン定義)
- E-02: `src/vs/workbench/contrib/localHistory/browser/localHistoryTimeline.ts` (LocalHistoryTimeline)
- E-03: `src/vs/workbench/services/workingCopy/common/workingCopyHistoryService.ts` (WorkingCopyHistoryModel)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (画面マッピング)
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` (機能定義)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LOCAL_HISTORY_ENABLED_SETTINGS_KEY設定 | E-02 (32行目) | ○ |
| C-02 | LocalHistoryTimelineがTimelineProviderを実装 | E-02 (28行目) | ○ |
| C-03 | scheme = '*' で全スキーマ対応 | E-02 (38行目) | ○ |
| C-04 | provideTimeline()でタイムライン生成 | E-02 (105-148行目) | ○ |
| C-05 | toTimelineItem()でエントリ変換 | E-02 (150-165行目) | ○ |
| C-06 | WorkingCopyHistoryModel.ENTRIES_FILE | E-03 (59行目) | ○ |
| C-07 | MAX_ENTRIES/MERGE_PERIOD設定キー | E-03 (63-66行目) | ○ |
| C-08 | addEntry()で履歴エントリ作成 | E-03 (122-155行目) | ○ |
| C-09 | マージウィンドウによる置換判定 | E-03 (129-135行目) | ○ |
| C-10 | doAddEntry()でcloneFile実行 | E-03 (157-185行目, 165行目) | ○ |
| C-11 | doReplaceEntry()でエントリ置換 | E-03 (187-205行目) | ○ |
| C-12 | removeEntry()でエントリ削除 | E-03 (207-239行目) | ○ |
| C-13 | updateEntry()でエントリ更新 | E-03 (241-268行目) | ○ |
| C-14 | getEntries()でmaxEntries考慮 | E-03 (270-282行目) | ○ |
| C-15 | toHistoryEntriesFolder()でハッシュベース格納 | E-03 (118-120行目) | ○ |
| C-16 | エントリIDはランダム4文字+拡張子 | E-03 (163行目) | ○ |
| C-17 | Limiter(1)による順次書き込み | E-03 (83行目) | ○ |
| C-18 | versionId/storedVersionIdによる変更追跡 | E-03 (80-81行目) | ○ |
| C-19 | flushOnChange設定による即時保存 | E-03 (150-152行目) | ○ |
| C-20 | LOCAL_HISTORY_MENU_CONTEXT_VALUE | E-01 (31行目) | ○ |
| C-21 | LOCAL_HISTORY_ICON_ENTRY/RESTORE | E-01 (34-35行目) | ○ |
| C-22 | 画面No.26 タイムラインビュー連携 | E-04 (75行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主張に根拠が確認できた。不足情報なし。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: インターフェース定義、設定キー
- **0（低リスク）**: 処理フロー、ファイル操作
- **0（低リスク）**: タイムライン連携

## 6) レビュアーチェックリスト（最小）
- [ ] WorkingCopyHistoryModelの主要メソッドが網羅されているか確認
- [ ] 設定項目（maxFileEntries, mergeWindow）の説明が正確か確認
- [ ] タイムライン連携の挙動が正確か確認
- [ ] 画面マッピング（No.26）が最新か確認
