---
generated_at: 2026-01-27 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：5-コードフォールディング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **折りたたみ範囲の上限値**：根拠不足
  2. **ビューステート保存の詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/editor/contrib/folding/browser/folding.ts` - FoldingController
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能関連情報
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FoldingControllerがID 'editor.contrib.folding'で登録 | E-01 (70行目) | ○ |
| C-02 | foldingStrategyオプションで'indentation'選択可能 | E-01 (131行目) | ○ |
| C-03 | CONTEXT_FOLDING_ENABLEDコンテキストキー | E-01 (46行目) | ○ |
| C-04 | RangeProviderインターフェースでid, compute, disposeを定義 | E-01 (48-52行目) | ○ |
| C-05 | FoldingStateMemento型でcollapsedRegions, lineCount等保持 | E-01 (54-59行目) | ○ |
| C-06 | FoldingLimitReporterで範囲制限を報告 | E-01 (61-64行目) | ○ |
| C-07 | FoldingRangeProviderSelectorで言語プロバイダ選択 | E-01 (66行目) | ○ |
| C-08 | foldingImportsByDefaultオプション | E-01 (93行目, 135行目) | ○ |
| C-09 | showFoldingControlsオプション | E-01 (148行目) | ○ |
| C-10 | foldingHighlightオプション | E-01 (149行目) | ○ |
| C-11 | unfoldOnClickAfterEndOfLineオプション | E-01 (91行目, 132行目) | ○ |
| C-12 | デバウンス最小200ms | E-01 (136行目) | ○ |
| C-13 | FoldingDecorationProviderでデコレーション管理 | E-01 (147行目) | ○ |
| C-14 | HiddenRangeModelで非表示範囲管理 | E-01 (99行目) | ○ |
| C-15 | FoldingModelで折りたたみモデル管理 | E-01 (98行目) | ○ |
| C-16 | テキストエディタが主画面として関連 | E-02 (33行目) | ○ |
| C-17 | 機能の備考にsrc/vs/editor/contrib/foldingが記載 | E-03 (6行目) | ○ |
| C-18 | IndentRangeProviderでインデントベース計算 | E-01 (29行目) | ○ |
| C-19 | 折りたたみ範囲の上限値 | **根拠なし** | △ |
| C-20 | ビューステート保存の詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 折りたたみ範囲の具体的な上限値はコード内に明示的記載がない
  - 候補：FoldingLimitReporter実装 / 設定オプション
- ビューステート保存の詳細はViewModelまたはエディタステートサービスにある
  - 候補：`src/vs/editor/common/viewModel`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラ構造はコードと一致
- 0: 低リスク - オプション名とデフォルト値はコードで確認可能
- 1: 中リスク - 上限値は実装詳細の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] FoldingController.IDが正しく登録されているか確認
- [ ] foldingStrategyオプションの'auto'と'indentation'の挙動を確認
- [ ] デバウンス200msの設定が適切か確認
- [ ] FoldingDecorationProviderのデコレーション表示を確認
- [ ] HiddenRangeModelの非表示範囲管理を確認
