---
generated_at: 2026-01-27 12:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：53-通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **トースト通知の自動非表示タイミング**：実装詳細の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/platform/notification/common/notification.ts` (14行目: INotificationService decorator)
- E-02: `src/vs/platform/notification/common/notification.ts` (18-39行目: NotificationPriority enum)
- E-03: `src/vs/platform/notification/common/notification.ts` (41-62行目: INotificationProperties)
- E-04: `src/vs/platform/notification/common/notification.ts` (64-82行目: NeverShowAgainScope)
- E-05: `src/vs/platform/notification/common/notification.ts` (128-172行目: INotification)
- E-06: `src/vs/platform/notification/common/notification.ts` (174-190行目: INotificationActions)
- E-07: `src/vs/platform/notification/common/notification.ts` (233-274行目: INotificationHandle)
- E-08: `src/vs/platform/notification/common/notification.ts` (371-454行目: INotificationService)
- E-09: `src/vs/platform/notification/common/notification.ts` (477-491行目: withSeverityPrefix)
- E-10: `src/vs/platform/notification/common/notification.ts` (284-332行目: IPromptChoice関連)
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (4,20,26,97,103行目: 関連画面)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NotificationPriorityはDEFAULT, OPTIONAL, SILENT, URGENTの4段階 | E-02 | ○ |
| C-02 | INotificationServiceにnotify/info/warn/error/prompt/statusメソッドがある | E-08 | ○ |
| C-03 | NeverShowAgainScopeはWORKSPACE, PROFILE, APPLICATIONの3種類 | E-04 | ○ |
| C-04 | INotificationPropertiesにsticky、priority、neverShowAgainがある | E-03 | ○ |
| C-05 | INotificationにseverity、message、actions、progressがある | E-05 | ○ |
| C-06 | INotificationActionsにprimary、secondaryアクションがある | E-06 | ○ |
| C-07 | INotificationHandleにonDidClose、updateMessage、close等がある | E-07 | ○ |
| C-08 | withSeverityPrefixでWCAG 4.1.3準拠のプレフィックス付与 | E-09 | ○ |
| C-09 | IPromptChoiceにlabel、run、isSecondaryがある | E-10 | ○ |
| C-10 | ワークベンチが通知センターを統合管理 | E-11 | ○ |
| C-11 | ステータスバーに通知アイコンを表示 | E-11 | ○ |
| C-12 | バナーで更新情報等を表示 | E-11 | ○ |
| C-13 | 通知センターで通知一覧を表示 | E-11 | ○ |
| C-14 | メッセージにMarkdownリンク形式をサポート | E-05 (145-147行目コメント) | ○ |
| C-15 | Sticky通知の自動非表示タイミング | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Sticky通知の自動非表示タイミングの具体的な秒数
  - 候補：workbench実装側のnotification実装を確認

## 5) リスクフラグ（レビュー観点）
- 0: NotificationPriority定義の正確性（低リスク - コード確認済み）
- 0: NeverShowAgainScope定義（低リスク - コード確認済み）
- 0: インターフェース定義（低リスク - コード確認済み）
- 1: 自動非表示タイミング（中リスク - workbench実装依存）

## 6) レビュアーチェックリスト（最小）
- [ ] NotificationPriorityの動作が説明と一致しているか確認
- [ ] NeverShowAgainの永続化スコープが正しいか確認
- [ ] WCAG 4.1.3準拠の記述が正確かアクセシビリティ観点で確認
- [ ] Sticky通知の自動非表示タイミングを追記する必要があるか検討
- [ ] Markdownリンクのセキュリティ制限を確認
