---
generated_at: 2026-01-27 12:30:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：54-ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があり、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/platform/dialogs/common/dialogs.ts` (273行目: IDialogService decorator)
- E-02: `src/vs/platform/dialogs/common/dialogs.ts` (27-40行目: IBaseDialogOptions)
- E-03: `src/vs/platform/dialogs/common/dialogs.ts` (46-57行目: IConfirmation)
- E-04: `src/vs/platform/dialogs/common/dialogs.ts` (59-65行目: IConfirmationResult)
- E-05: `src/vs/platform/dialogs/common/dialogs.ts` (71-78行目: IInput)
- E-06: `src/vs/platform/dialogs/common/dialogs.ts` (80-85行目: IInputElement)
- E-07: `src/vs/platform/dialogs/common/dialogs.ts` (120-133行目: IPrompt)
- E-08: `src/vs/platform/dialogs/common/dialogs.ts` (169行目: DialogType)
- E-09: `src/vs/platform/dialogs/common/dialogs.ts` (452-509行目: IDialogService)
- E-10: `src/vs/platform/dialogs/common/dialogs.ts` (511-587行目: IFileDialogService)
- E-11: `src/vs/platform/dialogs/common/dialogs.ts` (595行目: MAX_CONFIRM_FILES = 10)
- E-12: `src/vs/platform/dialogs/common/dialogs.ts` (596-610行目: getFileNamesMessage)
- E-13: `src/vs/platform/dialogs/common/dialogs.ts` (641-730行目: massageMessageBoxOptions)
- E-14: `src/vs/platform/dialogs/common/dialogs.ts` (654-696行目: Linux/macOSボタン配置)
- E-15: `src/vs/platform/dialogs/common/dialogs.ts` (697-716行目: Windowsボタン配置)
- E-16: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (98行目: ダイアログ画面)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IDialogServiceにconfirm/prompt/input/info/warn/error/aboutメソッドがある | E-09 | ○ |
| C-02 | IBaseDialogOptionsにtype, title, message, detail, checkbox, customがある | E-02 | ○ |
| C-03 | IConfirmationにprimaryButton, cancelButtonがある | E-03 | ○ |
| C-04 | IConfirmationResultにconfirmed, checkboxCheckedがある | E-04 | ○ |
| C-05 | IInputにinputs配列がある | E-05 | ○ |
| C-06 | IInputElementにtype(text/password), value, placeholderがある | E-06 | ○ |
| C-07 | IPromptにbuttons, cancelButtonがある | E-07 | ○ |
| C-08 | DialogTypeはnone/info/error/question/warningまたはSeverity | E-08 | ○ |
| C-09 | IFileDialogServiceにpickFile/pickFolder/showSave/showOpenDialogがある | E-10 | ○ |
| C-10 | MAX_CONFIRM_FILESは10件 | E-11 | ○ |
| C-11 | getFileNamesMessageで最大10件までファイル名を表示 | E-12 | ○ |
| C-12 | massageMessageBoxOptionsでプラットフォーム別調整 | E-13 | ○ |
| C-13 | Linux/macOSではキャンセルを先頭付近に配置 | E-14 | ○ |
| C-14 | Linuxではボタン配列を反転 | E-14 (688-696行目) | ○ |
| C-15 | Windowsではキャンセルを末尾に配置 | E-15 | ○ |
| C-16 | ダイアログ画面で確認・入力を行う | E-16 | ○ |
| C-17 | デフォルトボタンは最初のボタン | E-13 (647行目: defaultId = 0) | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主張に根拠があるため、不足情報はありません

## 5) リスクフラグ（レビュー観点）
- 0: ダイアログ型定義の正確性（低リスク - コード確認済み）
- 0: プラットフォーム別ボタン配置（低リスク - コード確認済み）
- 0: ファイルダイアログ機能（低リスク - コード確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] IDialogServiceのメソッド一覧が実装と一致しているか確認
- [ ] プラットフォーム別ボタン配置ロジックが正確か確認
- [ ] MAX_CONFIRM_FILES=10が適切な値か確認
- [ ] カスタムダイアログとネイティブダイアログの使い分け条件を確認
