---
generated_at: 2026-01-27 12:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：55-クイック入力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **仮想スクロールの実装詳細**：パフォーマンス要件の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/platform/quickinput/common/quickInput.ts` (918行目: IQuickInputService decorator)
- E-02: `src/vs/platform/quickinput/common/quickInput.ts` (274-279行目: QuickInputType enum)
- E-03: `src/vs/platform/quickinput/common/quickInput.ts` (33-100行目: IQuickPickItem)
- E-04: `src/vs/platform/quickinput/common/quickInput.ts` (102-113行目: IQuickPickSeparator)
- E-05: `src/vs/platform/quickinput/common/quickInput.ts` (284-377行目: IQuickInput)
- E-06: `src/vs/platform/quickinput/common/quickInput.ts` (479-706行目: IQuickPick)
- E-07: `src/vs/platform/quickinput/common/quickInput.ts` (711-768行目: IInputBox)
- E-08: `src/vs/platform/quickinput/common/quickInput.ts` (415-432行目: ItemActivation enum)
- E-09: `src/vs/platform/quickinput/common/quickInput.ts` (437-474行目: QuickPickFocus enum)
- E-10: `src/vs/platform/quickinput/common/quickInput.ts` (770-836行目: IQuickInputButton)
- E-11: `src/vs/platform/quickinput/common/quickInput.ts` (1036-1176行目: IQuickTree)
- E-12: `src/vs/platform/quickinput/common/quickInput.ts` (126-204行目: IPickOptions)
- E-13: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (99-101行目: コマンドパレット、クイックオープン)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IQuickInputServiceにpick/input/createQuickPick/createInputBox等がある | E-01 | ○ |
| C-02 | QuickInputTypeはQuickPick/InputBox/QuickWidget/QuickTreeの4種類 | E-02 | ○ |
| C-03 | IQuickPickItemにlabel, description, detail, picked等がある | E-03 | ○ |
| C-04 | IQuickPickSeparatorでセパレーターを定義 | E-04 | ○ |
| C-05 | IQuickInputにtitle, description, step, totalSteps, buttons等がある | E-05 | ○ |
| C-06 | IQuickPickにitems, activeItems, selectedItems, canSelectMany等がある | E-06 | ○ |
| C-07 | IInputBoxにvalue, placeholder, password, validationMessage等がある | E-07 | ○ |
| C-08 | ItemActivationはNONE/FIRST/SECOND/LASTの4種類 | E-08 | ○ |
| C-09 | QuickPickFocusはFirst/Second/Last/Next/Previous等の9種類 | E-09 | ○ |
| C-10 | IQuickInputButtonにiconPath, iconClass, tooltip等がある | E-10 | ○ |
| C-11 | IQuickTreeでツリー構造からの選択が可能 | E-11 | ○ |
| C-12 | IPickOptionsにmatchOnLabel/Description/Detail等がある | E-12 | ○ |
| C-13 | コマンドパレット（Ctrl+Shift+P）がこの機能を使用 | E-13 | ○ |
| C-14 | クイックオープン（Ctrl+P）がこの機能を使用 | E-13 | ○ |
| C-15 | canAcceptInBackgroundでピッカーを閉じずに選択可能 | E-06 (531行目) | ○ |
| C-16 | 大量アイテム時の仮想スクロール対応 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 仮想スクロールの実装詳細
  - 候補：quickInputList.tsの実装確認 / workbench側のlist実装確認

## 5) リスクフラグ（レビュー観点）
- 0: QuickInputType定義の正確性（低リスク - コード確認済み）
- 0: ItemActivation/QuickPickFocus定義（低リスク - コード確認済み）
- 0: インターフェース定義（低リスク - コード確認済み）
- 1: 仮想スクロール実装（中リスク - 実装詳細要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] QuickInputTypeの4種類が実装と一致しているか確認
- [ ] ItemActivationとQuickPickFocusの動作が説明と一致しているか確認
- [ ] IPickOptionsのmatchOn*オプションの動作を確認
- [ ] 仮想スクロールの実装詳細を追記する必要があるか検討
- [ ] パスワード入力のマスク処理を確認
