---
generated_at: 2026-01-27 12:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：56-ウィンドウ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があり、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/platform/window/common/window.ts` (22-26行目: WindowMinimumSize)
- E-02: `src/vs/platform/window/common/window.ts` (38-72行目: IOpenWindowOptions)
- E-03: `src/vs/platform/window/common/window.ts` (130-139行目: MenuSettings, MenuStyleConfiguration)
- E-04: `src/vs/platform/window/common/window.ts` (220-234行目: TitleBarSetting, TitlebarStyle, WindowControlsStyle)
- E-05: `src/vs/platform/window/common/window.ts` (256-280行目: getTitleBarStyle)
- E-06: `src/vs/platform/window/common/window.ts` (296行目: DEFAULT_CUSTOM_TITLEBAR_HEIGHT)
- E-07: `src/vs/platform/window/common/window.ts` (473-479行目: zoomLevelToZoomFactor, デフォルトサイズ)
- E-08: `src/vs/platform/window/common/window.ts` (188-214行目: IWindowSettings)
- E-09: `src/vs/platform/window/common/window.ts` (100-129行目: IWindowOpenable型)
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (3,6-7,106行目: ワークベンチ、タイトルバー、スプラッシュ)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WindowMinimumSizeでWIDTH=400, HEIGHT=270を定義 | E-01 | ○ |
| C-02 | WIDTH_WITH_VERTICAL_PANEL=600を定義 | E-01 | ○ |
| C-03 | IOpenWindowOptionsにforceNewWindow, forceReuseWindow等がある | E-02 | ○ |
| C-04 | MenuStyleConfigurationはCUSTOM/NATIVE/INHERITの3種類 | E-03 | ○ |
| C-05 | TitlebarStyleはNATIVE/CUSTOMの2種類 | E-04 | ○ |
| C-06 | WindowControlsStyleはNATIVE/CUSTOM/HIDDENの3種類 | E-04 | ○ |
| C-07 | getTitleBarStyleでプラットフォーム別にスタイルを判定 | E-05 | ○ |
| C-08 | Webでは常にCUSTOMタイトルバー | E-05 (257-259行目) | ○ |
| C-09 | nativeTabsやsimpleFullScreen時はNATIVE | E-05 (263-271行目) | ○ |
| C-10 | DEFAULT_CUSTOM_TITLEBAR_HEIGHT=35 | E-06 | ○ |
| C-11 | zoomLevelToZoomFactor: scale = 1.2 ^ level | E-07 | ○ |
| C-12 | DEFAULT_EMPTY_WINDOW_SIZE: 1200x800 | E-07 | ○ |
| C-13 | DEFAULT_WORKSPACE_WINDOW_SIZE: 1440x900 | E-07 | ○ |
| C-14 | IWindowSettingsにtitleBarStyle, menuBarVisibility, zoomLevel等がある | E-08 | ○ |
| C-15 | IWindowOpenableはworkspace/folder/fileの3種類 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主張に根拠があるため、不足情報はありません

## 5) リスクフラグ（レビュー観点）
- 0: WindowMinimumSize定義（低リスク - コード確認済み）
- 0: TitlebarStyle/WindowControlsStyle定義（低リスク - コード確認済み）
- 0: ズームレベル計算式（低リスク - コード確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] WindowMinimumSizeの値が適切か確認
- [ ] TitlebarStyleのプラットフォーム別判定ロジックを確認
- [ ] ズームレベル計算式が正しいか確認
- [ ] デフォルトウィンドウサイズが適切か確認
