---
generated_at: 2026-01-27 12:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：57-メニュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があり、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/platform/menubar/common/menubar.ts` (8-9行目: ICommonMenubarService)
- E-02: `src/vs/platform/menubar/common/menubar.ts` (12-15行目: IMenubarData)
- E-03: `src/vs/platform/menubar/common/menubar.ts` (17-19行目: IMenubarMenu)
- E-04: `src/vs/platform/menubar/common/menubar.ts` (21-25行目: IMenubarKeybinding)
- E-05: `src/vs/platform/menubar/common/menubar.ts` (27-32行目: IMenubarMenuItemAction)
- E-06: `src/vs/platform/menubar/common/menubar.ts` (34-40行目: IMenubarMenuRecentItemAction)
- E-07: `src/vs/platform/menubar/common/menubar.ts` (42-46行目: IMenubarMenuItemSubmenu)
- E-08: `src/vs/platform/menubar/common/menubar.ts` (48-50行目: IMenubarMenuItemSeparator)
- E-09: `src/vs/platform/menubar/common/menubar.ts` (54-68行目: 型ガード関数)
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (6行目: タイトルバー)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ICommonMenubarServiceにupdateMenubarメソッドがある | E-01 | ○ |
| C-02 | IMenubarDataにmenus、keybindingsがある | E-02 | ○ |
| C-03 | IMenubarMenuにitemsがある | E-03 | ○ |
| C-04 | IMenubarKeybindingにlabel、userSettingsLabel、isNativeがある | E-04 | ○ |
| C-05 | IMenubarMenuItemActionにid、label、checked、enabledがある | E-05 | ○ |
| C-06 | IMenubarMenuRecentItemActionにuri、remoteAuthorityがある | E-06 | ○ |
| C-07 | IMenubarMenuItemSubmenuにsubmenuがある | E-07 | ○ |
| C-08 | セパレーターはid='vscode.menubar.separator'で識別 | E-08 | ○ |
| C-09 | isMenubarMenuItemSubmenuでsubmenuの有無を判定 | E-09 | ○ |
| C-10 | isMenubarMenuItemSeparatorでセパレーターを判定 | E-09 | ○ |
| C-11 | isMenubarMenuItemRecentActionでuriの有無を判定 | E-09 | ○ |
| C-12 | タイトルバーでメインメニューを表示 | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主張に根拠があるため、不足情報はありません

## 5) リスクフラグ（レビュー観点）
- 0: メニュー型定義の正確性（低リスク - コード確認済み）
- 0: 型ガード関数（低リスク - コード確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] IMenubarDataの構造が実装と一致しているか確認
- [ ] 型ガード関数の判定ロジックが正しいか確認
- [ ] セパレーターIDの文字列が正しいか確認
