---
generated_at: 2026-01-27 12:50:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：58-プロセス

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があり、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/platform/process/common/process.ts` (32行目: IProcessService decorator)
- E-02: `src/vs/platform/process/common/process.ts` (34-40行目: IResolvedProcessInformation)
- E-03: `src/vs/platform/process/common/process.ts` (42-51行目: IProcessService interface)
- E-04: `src/vs/platform/process/common/process.ts` (12-19行目: WindowStyles, WindowData)
- E-05: `src/vs/platform/process/common/process.ts` (21-25行目: IssueSource enum)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (53行目: プロセスエクスプローラー)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IProcessServiceはcreateDecorator('processService')で登録 | E-01 | ○ |
| C-02 | IResolvedProcessInformationにpidToNamesとprocessesがある | E-02 | ○ |
| C-03 | processesはnameとrootProcessの配列 | E-02 | ○ |
| C-04 | rootProcessはProcessItemまたはIRemoteDiagnosticError | E-02 | ○ |
| C-05 | IProcessServiceにresolveProcessesメソッドがある | E-03 | ○ |
| C-06 | IProcessServiceにgetSystemStatus/getSystemInfo/getPerformanceInfoがある | E-03 | ○ |
| C-07 | WindowStylesにmenuBarVisibility、zoomLevel等がある | E-04 | ○ |
| C-08 | IssueSourceにIssueReporter、ProcessExplorer等がある | E-05 | ○ |
| C-09 | プロセスエクスプローラーでリソース使用状況を表示 | E-06 | ○ |
| C-10 | リモート診断エラー時はIRemoteDiagnosticErrorを返す | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主張に根拠があるため、不足情報はありません

## 5) リスクフラグ（レビュー観点）
- 0: IProcessServiceインターフェース（低リスク - コード確認済み）
- 0: IResolvedProcessInformation型（低リスク - コード確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] IProcessServiceのメソッドシグネチャが正しいか確認
- [ ] IResolvedProcessInformationの構造が実装と一致しているか確認
- [ ] プロセスエクスプローラーとの連携が正しいか確認
