---
generated_at: 2026-01-27 10:55:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：6-検索・置換

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **ReDoS対策の詳細**：根拠不足
  2. **大規模ファイル検索パフォーマンス**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/editor/contrib/find/browser/findController.ts` - CommonFindController
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能関連情報
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CommonFindControllerがID 'editor.contrib.findController'で登録 | E-01 (94行目) | ○ |
| C-02 | SEARCH_STRING_MAX_LENGTH = 524288 | E-01 (38行目) | ○ |
| C-03 | getSelectionSearchString()で選択テキストから検索文字列取得 | E-01 (40-63行目) | ○ |
| C-04 | FindStartFocusAction列挙型定義 | E-01 (65-69行目) | ○ |
| C-05 | IFindStartOptions型でforceRevealReplace等定義 | E-01 (71-80行目) | ○ |
| C-06 | IFindStartArguments型でsearchString等定義 | E-01 (82-90行目) | ○ |
| C-07 | seedSearchStringFromSelectionで'none'/'single'/'multiple'選択 | E-01 (73行目, 48-49行目) | ○ |
| C-08 | _updateHistoryDelayerで500ms遅延 | E-01 (132行目) | ○ |
| C-09 | CONTEXT_FIND_WIDGET_VISIBLEコンテキストキー | E-01 (125行目) | ○ |
| C-10 | StorageServiceに検索オプション保存 | E-01 (146-149行目) | ○ |
| C-11 | matchCase, wholeWord, isRegex, preserveCaseオプション | E-01 (146-149行目) | ○ |
| C-12 | FindReplaceStateで状態管理 | E-01 (133行目) | ○ |
| C-13 | テキストエディタが主画面として関連 | E-02 (34行目) | ○ |
| C-14 | 機能の備考にsrc/vs/editor/contrib/findが記載 | E-03 (7行目) | ○ |
| C-15 | seedSearchStringFromNonEmptySelectionオプション | E-01 (74行目, 52行目) | ○ |
| C-16 | seedSearchStringFromGlobalClipboardオプション | E-01 (75行目) | ○ |
| C-17 | loopオプションで検索ループ制御 | E-01 (79行目) | ○ |
| C-18 | 選択が空の場合getConfiguredWordAtPositionで単語取得 | E-01 (51-53行目) | ○ |
| C-19 | ReDoS対策の詳細実装 | **根拠なし** | △ |
| C-20 | 大規模ファイル検索1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ReDoS対策の詳細はコード内に明示的記載がない
  - 候補：正規表現ライブラリ / タイムアウト設定
- パフォーマンス要件の具体的数値は推定値
  - 候補：ベンチマークテスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラ構造はコードと一致
- 0: 低リスク - 検索オプションの種類はコードで確認可能
- 1: 中リスク - セキュリティ対策の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] CommonFindController.IDが正しく登録されているか確認
- [ ] SEARCH_STRING_MAX_LENGTHが適用されているか確認
- [ ] 検索履歴の500ms遅延保存が動作するか確認
- [ ] 各検索オプションがStorageServiceに保存されるか確認
- [ ] getSelectionSearchString()の単語取得ロジックを確認
