---
generated_at: 2026-01-27 12:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：61-MCP

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の数値**：具体的な設定値の根拠不足
  2. **リトライ仕様**：実装箇所の特定が困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/platform/mcp/common/mcpPlatformTypes.ts` - MCP型定義
- E-02: `src/vs/platform/mcp/common/mcpManagement.ts` - MCPサービスインターフェース
- E-03: `src/vs/platform/mcp/common/mcpManagementService.ts` - MCPサーバー管理実装
- E-04: `src/vs/platform/mcp/common/mcpGalleryService.ts` - ギャラリーサービス実装
- E-05: `src/vs/platform/mcp/common/mcpResourceScannerService.ts` - リソーススキャナー
- E-06: `src/vs/workbench/api/browser/mainThreadMcp.ts` - メインスレッドMCP
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MCPはAIエージェントとの連携プロトコル | E-02, E-06 | ○ |
| C-02 | サーバータイプはstdioとhttpの2種類 | E-01 (McpServerType) | ○ |
| C-03 | mcp.jsonから設定を読み込む | E-05 (scanMcpServers) | ○ |
| C-04 | MCPギャラリーからサーバー検索可能 | E-04 (query) | ○ |
| C-05 | OAuth認証に対応 | E-06 ($getTokenForProviderId) | ○ |
| C-06 | npm/pip/dockerパッケージ対応 | E-02 (RegistryType) | ○ |
| C-07 | 変数置換機能あり | E-03 (getVariables) | ○ |
| C-08 | ワークスペース信頼との連携 | E-06 (trustBehavior) | ○ |
| C-09 | JSON-RPCプロトコル使用 | E-06 (MCP.JSONRPCMessage) | ○ |
| C-10 | ファイル監視による設定自動更新 | E-03 (startWatching) | ○ |
| C-11 | サーバー状態監視機能 | E-06 (McpConnectionState) | ○ |
| C-12 | インストール/アンインストール機能 | E-03 (install, uninstall) | ○ |
| C-13 | ギャラリーメタデータ更新 | E-03 (updateMetadataFromGallery) | ○ |
| C-14 | 許可リスト機能 | E-02 (IAllowedMcpServersService) | ○ |
| C-15 | シークレットストレージ使用 | E-06 (認証処理) | ○ |
| C-16 | 複数スキーマバージョン対応 | E-04 (galleryMcpServerDataSerializers) | ○ |
| C-17 | 5秒以内のサーバー起動要件 | **根拠なし** | △ |
| C-18 | 最大3回のリトライ | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値（タイムアウト値、リトライ回数等）は設定や実装を詳細に調査する必要がある
  - 候補：設定ファイル / コンスタント定義 / 実行時設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 型定義とインターフェースは正確に記載
- 0: 低リスク - 処理フローは実装に基づく
- 1: 中リスク - パフォーマンス要件は仮置きの可能性

## 6) レビュアーチェックリスト（最小）
- [ ] McpServerTypeの種類が実装と一致しているか確認
- [ ] mcp.json設定ファイルのパスが正しいか確認
- [ ] 認証フローが実際の動作と一致しているか確認
- [ ] パフォーマンス要件の数値を実装/設定から確認
