---
generated_at: 2026-01-27 12:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：62-拡張機能ホスト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **リトライ仕様の詳細**：クラッシュ時の再起動条件の詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/api/common/extHostExtensionService.ts` - 拡張機能サービス実装
- E-02: `src/vs/workbench/api/common/extHostExtensionActivator.ts` - アクティベーション管理
- E-03: `src/vs/workbench/api/common/extHost.protocol.ts` - RPCプロトコル
- E-04: `src/vs/workbench/api/common/extHost.api.impl.ts` - API実装
- E-05: `src/vs/platform/extensions/common/extensions.ts` - 拡張機能型定義
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 拡張機能は別プロセスで実行 | E-01 (AbstractExtHostExtensionService) | ○ |
| C-02 | メインプロセスとRPC通信 | E-03 (MainContext, ExtHostContext) | ○ |
| C-03 | 依存関係順序でアクティベート | E-02 (ExtensionsActivator) | ○ |
| C-04 | IExtensionDescriptionでメタデータ管理 | E-05 (interface定義) | ○ |
| C-05 | 提案APIは許可が必要 | E-01 (checkProposedApiEnabled) | ○ |
| C-06 | engines.vscodeでAPIバージョン指定 | E-05 (IExtensionDescription.engines) | ○ |
| C-07 | activate()関数でアクティベーション | E-02 (actualActivateExtension) | ○ |
| C-08 | vscode名前空間をAPI提供 | E-04 (createApiFactoryAndRegisterActors) | ○ |
| C-09 | Desktop版はNode.js、Web版はWorker | E-01 (ExtensionRuntime) | ○ |
| C-10 | レジストリで拡張機能管理 | E-01 (ExtensionDescriptionRegistry) | ○ |
| C-11 | ストレージで永続化 | E-01 (ExtHostStorage) | ○ |
| C-12 | '*'イベントで即座アクティベート | E-02 (activationEvents処理) | ○ |
| C-13 | リモート開発対応 | E-01 (remoteAuthority) | ○ |
| C-14 | アクティベーション時間計測 | E-02 (ExtensionActivationTimes) | ○ |
| C-15 | ワークスペース信頼との連携 | E-01 (workspace trust関連) | ○ |
| C-16 | クラッシュ時の自動再起動条件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- クラッシュ時の再起動ポリシー（何回のクラッシュで停止するか等）の詳細な実装箇所
  - 候補：ExtensionHostManager / extensionHost.contribution.ts

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能は正確に記載
- 0: 低リスク - RPC通信パターンは実装通り
- 1: 中リスク - クラッシュ再起動の詳細仕様

## 6) レビュアーチェックリスト（最小）
- [ ] ExtensionsActivatorの依存関係解決ロジックが正しく記載されているか
- [ ] RPC通信のProxy/Stubパターンの説明が正確か
- [ ] Desktop版とWeb版の差異が正しく記載されているか
- [ ] クラッシュ再起動の条件を実装から確認
