---
generated_at: 2026-01-27 12:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：63-拡張機能管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **リトライ仕様の詳細**：ダウンロード失敗時のリトライ回数

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/platform/extensionManagement/common/extensionManagement.ts` - 型定義とサービスインターフェース
- E-02: `src/vs/platform/extensionManagement/common/extensionGalleryService.ts` - ギャラリーサービス
- E-03: `src/vs/platform/extensions/common/extensions.ts` - 拡張機能型定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | マーケットプレイスからインストール可能 | E-01 (IExtensionGalleryService) | ○ |
| C-02 | IGalleryExtensionでマーケットプレイス拡張機能を表現 | E-01 (interface定義) | ○ |
| C-03 | ILocalExtensionでインストール済みを表現 | E-01 (interface定義) | ○ |
| C-04 | 署名検証機能あり | E-01 (ExtensionSignatureVerificationCode) | ○ |
| C-05 | 許可リスト機能 | E-01 (IAllowedExtensionsService) | ○ |
| C-06 | ターゲットプラットフォーム対応 | E-01 (TargetPlatform) | ○ |
| C-07 | プレリリース版対応 | E-01 (preRelease属性) | ○ |
| C-08 | 悪意ある拡張機能リスト | E-01 (IExtensionsControlManifest.malicious) | ○ |
| C-09 | 自動更新機能 | E-01 (autoUpdate設定) | ○ |
| C-10 | VSIXファイルからインストール | E-01 (install(vsix)) | ○ |
| C-11 | 拡張機能サイズ計算 | E-01 (computeSize) | ○ |
| C-12 | エラーコード定義 | E-01 (ExtensionManagementErrorCode) | ○ |
| C-13 | 互換性チェック機能 | E-01 (isExtensionCompatible) | ○ |
| C-14 | HTTPSでダウンロード | E-02 (download実装) | ○ |
| C-15 | 最大3回のリトライ | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ダウンロードリトライの詳細な実装（回数、間隔等）
  - 候補：extensionGalleryService.ts内のdownload処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 型定義は正確
- 0: 低リスク - サービスインターフェースは正確
- 1: 中リスク - リトライ仕様の詳細

## 6) レビュアーチェックリスト（最小）
- [ ] 署名検証コードの列挙値が実装と一致しているか
- [ ] 許可リスト設定のキー名が正しいか
- [ ] エラーコードが網羅されているか
- [ ] ダウンロードリトライの実装を確認
