---
generated_at: 2026-01-27 12:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：64-言語機能

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/api/common/extHostLanguageFeatures.ts` - 言語機能ホスト側実装
- E-02: `src/vs/workbench/api/common/extHostTypes.ts` - API型定義
- E-03: `src/vs/workbench/api/common/extHostTypeConverters.ts` - 型変換ユーティリティ
- E-04: `src/vs/editor/common/languages.ts` - エディタ内部型
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CompletionItemProviderで補完提供 | E-01 (provideCompletionItems) | ○ |
| C-02 | DefinitionProviderで定義へ移動 | E-01 (DefinitionAdapter) | ○ |
| C-03 | HoverProviderでホバー情報 | E-01 (HoverAdapter) | ○ |
| C-04 | DocumentSymbolProviderでシンボル | E-01 (DocumentSymbolAdapter) | ○ |
| C-05 | CodeLensProviderでCodeLens | E-01 (CodeLensAdapter) | ○ |
| C-06 | Adapterパターンで変換 | E-01 (各Adapterクラス) | ○ |
| C-07 | CancellationTokenでキャンセル | E-01 (token引数) | ○ |
| C-08 | 型変換ユーティリティ | E-03 (from/toメソッド) | ○ |
| C-09 | DocumentSelectorで対象フィルタ | E-01 (registerProvider) | ○ |
| C-10 | 複数プロバイダー登録可能 | E-01 (_adapter管理) | ○ |
| C-11 | resolve()で遅延解決 | E-01 (resolveCodeLens等) | ○ |
| C-12 | Cacheで結果キャッシュ | E-01 (Cache class) | ○ |
| C-13 | SemanticTokensProvider | E-01 (semanticTokens実装) | ○ |
| C-14 | RPC経由でメインスレッドと通信 | E-01 (MainThreadXxx参照) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり
- 0: 低リスク - Adapterパターンは明確
- 0: 低リスク - 型変換は実装通り

## 6) レビュアーチェックリスト（最小）
- [ ] 各Adapterの責務が正しく記載されているか
- [ ] 型変換処理の説明が正確か
- [ ] パフォーマンス要件の数値が妥当か
