---
generated_at: 2026-01-27 12:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：65-デバッグ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の数値**：具体的なタイムアウト設定の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/api/common/extHostDebugService.ts` - デバッグサービス実装
- E-02: `src/vs/workbench/api/common/extHostTypes.ts` - API型定義
- E-03: `src/vs/workbench/contrib/debug/common/debug.ts` - 内部型定義
- E-04: `src/vs/workbench/contrib/debug/common/abstractDebugAdapter.ts` - アダプター基底クラス
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DebugConfigurationProviderで設定解決 | E-01 (registerDebugConfigurationProvider) | ○ |
| C-02 | DebugAdapterDescriptorFactoryでアダプター生成 | E-01 (registerDebugAdapterDescriptorFactory) | ○ |
| C-03 | DAPプロトコル使用 | E-03, E-04 | ○ |
| C-04 | Executable/Server/Inlineのアダプタータイプ | E-02 (DebugAdapterExecutable等) | ○ |
| C-05 | ブレークポイント管理API | E-01 (breakpoints, addBreakpoints等) | ○ |
| C-06 | デバッグセッションイベント | E-01 (onDidStartDebugSession等) | ○ |
| C-07 | 設定解決順序（resolveDebugConfiguration） | E-01 (resolveDebugConfiguration) | ○ |
| C-08 | デバッグコンソール出力 | E-01 (activeDebugConsole) | ○ |
| C-09 | DebugAdapterTrackerFactoryで通信監視 | E-01 (registerDebugAdapterTrackerFactory) | ○ |
| C-10 | DebugVisualizationProvider | E-01 (registerDebugVisualizationProvider) | ○ |
| C-11 | スタック/スレッドフォーカス管理 | E-01 (activeStackItem) | ○ |
| C-12 | asDebugSourceUri変換 | E-01 (asDebugSourceUri) | ○ |
| C-13 | 複数ブレークポイントタイプ | E-02 (SourceBreakpoint, FunctionBreakpoint等) | ○ |
| C-14 | デバッグビジュアライザーツリー | E-01 (registerDebugVisualizationTree) | ○ |
| C-15 | ステップ実行1秒以内の応答要件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な設定値
  - 候補：設定ファイル / debugConfiguration

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - DAPプロトコル対応は正確
- 0: 低リスク - プロバイダー登録メソッドは正確
- 1: 中リスク - パフォーマンス要件の数値

## 6) レビュアーチェックリスト（最小）
- [ ] アダプタータイプ（Executable/Server/Inline）の説明が正確か
- [ ] ブレークポイント種別が網羅されているか
- [ ] DAPメッセージフローが正しいか
- [ ] パフォーマンス要件を実装から確認
