---
generated_at: 2026-01-27 12:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：66-Webview

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/api/common/extHostWebview.ts` - Webview実装
- E-02: `src/vs/workbench/api/common/extHostWebviewPanels.ts` - パネル管理
- E-03: `src/vs/workbench/api/common/extHostWebviewView.ts` - ビュー管理
- E-04: `src/vs/workbench/api/common/extHostWebviewMessaging.ts` - メッセージ通信
- E-05: `src/vs/workbench/contrib/webview/common/webview.ts` - 共通定義
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTMLコンテンツをWebviewに設定可能 | E-01 (html setter) | ○ |
| C-02 | asWebviewUri()でリソースURI変換 | E-01 (asWebviewUri) | ○ |
| C-03 | postMessage()でメッセージ送信 | E-01 (postMessage) | ○ |
| C-04 | onDidReceiveMessageでメッセージ受信 | E-01 (_onMessageEmitter) | ○ |
| C-05 | CSPソース取得可能 | E-01 (cspSource) | ○ |
| C-06 | WebviewOptionsで設定可能 | E-01 (options getter/setter) | ○ |
| C-07 | serializeBuffersForPostMessage対応 | E-01 (shouldSerializeBuffersForPostMessage) | ○ |
| C-08 | 古いvscode-resource URI書き換え | E-01 (rewriteOldResourceUrlsIfNeeded) | ○ |
| C-09 | ExtHostWebviewsでWebview管理 | E-01 (ExtHostWebviews class) | ○ |
| C-10 | WebviewPanel作成API | E-02 | ○ |
| C-11 | WebviewView登録API | E-03 | ○ |
| C-12 | メッセージシリアライズ | E-04 (serializeWebviewMessage) | ○ |
| C-13 | WebviewRemoteInfo管理 | E-05 | ○ |
| C-14 | dispose時のクリーンアップ | E-01 (dispose method) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり
- 0: 低リスク - API設計は実装通り
- 0: 低リスク - セキュリティ考慮事項も正確

## 6) レビュアーチェックリスト（最小）
- [ ] asWebviewUri()の変換ロジックが正しく記載されているか
- [ ] CSP設定の推奨事項が正確か
- [ ] メッセージシリアライズの仕様が正確か
