---
generated_at: 2026-01-27 12:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：67-JavaScript/TypeScript

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の数値**：応答時間の具体値

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/typescript-language-features/src/extension.ts` - エントリーポイント
- E-02: `extensions/typescript-language-features/src/typeScriptServiceClientHost.ts` - サービスホスト
- E-03: `extensions/typescript-language-features/src/tsServer/server.ts` - サーバー管理
- E-04: `extensions/typescript-language-features/src/languageFeatures/completions.ts` - 補完機能
- E-05: `extensions/typescript-language-features/src/tsServer/bufferSyncSupport.ts` - ファイル同期
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | tsserverをバックエンドとして使用 | E-03 (ServerProcess) | ○ |
| C-02 | PluginManagerでプラグイン管理 | E-01 (PluginManager) | ○ |
| C-03 | BufferSyncSupportでファイル同期 | E-05 | ○ |
| C-04 | コード補完機能 | E-04 (provideCompletionItems) | ○ |
| C-05 | 定義へ移動機能 | E-01 (registerBaseCommands) | ○ |
| C-06 | TSGOモード対応 | E-01 (useTsgo設定) | ○ |
| C-07 | バージョン選択機能 | E-01 (versionProvider) | ○ |
| C-08 | リクエストキュー管理 | E-03 (requestQueue) | ○ |
| C-09 | 診断情報提供 | E-02 (diagnostics) | ○ |
| C-10 | セマンティックトークン | E-04関連 (semanticTokens) | ○ |
| C-11 | CodeLens機能 | E-01 (referencesCodeLens等) | ○ |
| C-12 | tsserverクラッシュ時再起動 | E-03 (restart処理) | ○ |
| C-13 | 条件付き機能登録 | E-01 (conditionalRegistration) | ○ |
| C-14 | 補完候補300ms以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値設定
  - 候補：設定ファイル / tsserver設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - tsserver連携は正確
- 0: 低リスク - 言語機能の実装は正確
- 1: 中リスク - パフォーマンス数値の検証

## 6) レビュアーチェックリスト（最小）
- [ ] tsserverとの通信プロトコルが正しく記載されているか
- [ ] BufferSyncSupportの同期タイミングが正しいか
- [ ] TSGOモードの条件分岐が正しいか
- [ ] パフォーマンス要件を設定/実装から確認
