---
generated_at: 2026-01-27 12:50:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：68-JSON

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/json-language-features/client/src/jsonClient.ts` - メインクライアント
- E-02: `extensions/json-language-features/client/src/node/jsonClientMain.ts` - Node.jsエントリー
- E-03: `extensions/json-language-features/client/src/languageStatus.ts` - ステータス表示
- E-04: `extensions/json-language-features/client/src/node/schemaCache.ts` - スキーマキャッシュ
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LSP準拠のJSON Language Server | E-01 (LanguageClient) | ○ |
| C-02 | スキーマ関連付け機能 | E-01 (SchemaAssociationNotification) | ○ |
| C-03 | VSCodeContentRequestでスキーマ取得 | E-01 (VSCodeContentRequest) | ○ |
| C-04 | スキーマ検証機能 | E-01 (ForceValidateRequest) | ○ |
| C-05 | 信頼ドメイン設定 | E-01 (SettingIds.trustedDomains) | ○ |
| C-06 | maxItemsComputed設定 | E-01 (SettingIds.maxItemsComputed) | ○ |
| C-07 | フォーマット有効/無効設定 | E-01 (SettingIds.enableFormatter) | ○ |
| C-08 | LanguageStatusでスキーマ表示 | E-03 (createSchemaLoadStatusItem) | ○ |
| C-09 | スキーマキャッシュ機能 | E-04 | ○ |
| C-10 | カラーデコレーション | E-01 (DocumentColorProvider) | ○ |
| C-11 | 折りたたみ機能 | E-01 (FoldingRangeProvider) | ○ |
| C-12 | ソート機能 | E-01 (DocumentSortingRequest) | ○ |
| C-13 | コードアクション | E-01 (CodeAction) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり
- 0: 低リスク - LSP通信パターンは正確
- 0: 低リスク - スキーマ関連付けは実装通り

## 6) レビュアーチェックリスト（最小）
- [ ] スキーマ関連付けのパターンマッチングが正しく記載されているか
- [ ] 信頼ドメイン設定の動作が正確か
- [ ] スキーマキャッシュの仕組みが正確か
