---
generated_at: 2026-01-27 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：7-マルチカーソル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **カーソル数上限のデフォルト値**：根拠不足
  2. **列選択モードの詳細実装**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/editor/contrib/multicursor/browser/multicursor.ts` - マルチカーソルアクション
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能関連情報
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InsertCursorAboveがID 'editor.action.insertCursorAbove'で登録 | E-01 (50行目) | ○ |
| C-02 | InsertCursorBelowがID 'editor.action.insertCursorBelow'で登録 | E-01 (102行目) | ○ |
| C-03 | Ctrl+Alt+UpArrowでカーソル上追加 | E-01 (55行目) | ○ |
| C-04 | Ctrl+Alt+DownArrowでカーソル下追加 | E-01 (107行目) | ○ |
| C-05 | LinuxではShift+Alt+Up/Downが主要キーバインド | E-01 (56-58行目, 108-110行目) | ○ |
| C-06 | logicalLineパラメータで論理行モード制御 | E-01 (43行目, 76-79行目) | ○ |
| C-07 | 読み取り専用チェックでcursorConfig.readOnly確認 | E-01 (82-84行目, 134-136行目) | ○ |
| C-08 | pushStackElement()でUndo境界作成 | E-01 (86行目, 138行目) | ○ |
| C-09 | CursorMoveCommands.addCursorUp/Downで計算 | E-01 (91行目, 143行目) | ○ |
| C-10 | setCursorStates()でカーソル状態設定 | E-01 (88-92行目, 140-144行目) | ○ |
| C-11 | revealTopMost/BottomMostCursor()でスクロール | E-01 (93行目, 145行目) | ○ |
| C-12 | announceCursorChange()でアクセシビリティ通知 | E-01 (32-39行目, 94行目, 146行目) | ○ |
| C-13 | status()でスクリーンリーダー通知 | E-01 (37行目) | ○ |
| C-14 | テキストエディタが主画面として関連 | E-02 (35行目) | ○ |
| C-15 | 機能の備考にsrc/vs/editor/contrib/multicursorが記載 | E-03 (8行目) | ○ |
| C-16 | MenuId.MenubarSelectionMenuにアクション登録 | E-01 (63行目, 115行目) | ○ |
| C-17 | カーソル数上限のデフォルト値10000 | **根拠なし** | △ |
| C-18 | 列選択モードの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- カーソル数上限のデフォルト値はエディタオプションで設定
  - 候補：`src/vs/editor/common/config/editorOptions.ts`
- 列選択モードは別のコードパスで実装されている可能性
  - 候補：マウスハンドラー / 選択モード設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - アクション定義はコードと一致
- 0: 低リスク - キーバインドはコードで確認可能
- 1: 中リスク - 上限値の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] InsertCursorAbove/Belowのアクション定義を確認
- [ ] キーバインドがプラットフォームごとに正しいか確認
- [ ] logicalLineパラメータの動作を確認
- [ ] announceCursorChange()のアクセシビリティメッセージを確認
- [ ] カーソル数上限の設定箇所を特定
